/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.awaitility.core;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.testcontainers.shaded.org.awaitility.core.ConditionEvaluationListener;
import org.testcontainers.shaded.org.awaitility.core.EvaluatedCondition;
import org.testcontainers.shaded.org.awaitility.core.IgnoredException;
import org.testcontainers.shaded.org.awaitility.core.StartEvaluationEvent;
import org.testcontainers.shaded.org.awaitility.core.TemporalDuration;
import org.testcontainers.shaded.org.awaitility.core.TimeoutEvent;

public class ConditionEvaluationLogger
implements ConditionEvaluationListener<Object> {
    private final Consumer<String> logPrinter;
    private final TimeUnit unit;

    public ConditionEvaluationLogger() {
        this(TimeUnit.MILLISECONDS);
    }

    public ConditionEvaluationLogger(Consumer<String> logPrinter) {
        this(logPrinter, TimeUnit.MILLISECONDS);
    }

    public ConditionEvaluationLogger(TimeUnit unit) {
        this(System.out::println, unit);
    }

    public ConditionEvaluationLogger(Consumer<String> logPrinter, TimeUnit unit) {
        if (logPrinter == null) {
            throw new IllegalArgumentException("LogPrinter cannot be null");
        }
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        this.logPrinter = logPrinter;
        this.unit = unit;
    }

    @Override
    public void conditionEvaluated(EvaluatedCondition<Object> condition) {
        String description = condition.getDescription();
        long elapsedTime = this.unit.convert(condition.getElapsedTimeInMS(), TimeUnit.MILLISECONDS);
        long remainingTime = this.unit.convert(condition.getRemainingTimeInMS(), TimeUnit.MILLISECONDS);
        String unitAsString = this.unit.toString().toLowerCase();
        String message = condition.isSatisfied() ? String.format("%s after %d %s (remaining time %d %s, last poll interval was %s)", description, elapsedTime, unitAsString, remainingTime, unitAsString, new TemporalDuration(condition.getPollInterval()).toString()) : String.format("%s (elapsed time %d %s, remaining time %d %s (last poll interval was %s))", description, elapsedTime, unitAsString, remainingTime, unitAsString, new TemporalDuration(condition.getPollInterval()).toString());
        this.logPrinter.accept(message);
    }

    @Override
    public void beforeEvaluation(StartEvaluationEvent<Object> condition) {
        this.logPrinter.accept(condition.getDescription());
    }

    @Override
    public void onTimeout(TimeoutEvent timeoutEvent) {
        this.logPrinter.accept(String.format("%s", timeoutEvent.getDescription()));
    }

    @Override
    public void exceptionIgnored(IgnoredException ignoredException) {
        this.logPrinter.accept(String.format("Exception %s has been ignored", ignoredException.getThrowable().getMessage()));
    }

    public static ConditionEvaluationLogger conditionEvaluationLogger(Consumer<String> logger) {
        return new ConditionEvaluationLogger(logger);
    }

    public static ConditionEvaluationLogger conditionEvaluationLogger() {
        return new ConditionEvaluationLogger();
    }

    public static ConditionEvaluationLogger conditionEvaluationLogger(TimeUnit unit) {
        return new ConditionEvaluationLogger(unit);
    }
}

