/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.model.Image;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.NonNull;

public final class ImageData {
    @NonNull
    private final Instant createdAt;

    static ImageData from(InspectImageResponse inspectImageResponse) {
        return ImageData.builder().createdAt(ZonedDateTime.parse(inspectImageResponse.getCreated()).toInstant()).build();
    }

    static ImageData from(Image image) {
        return ImageData.builder().createdAt(Instant.ofEpochSecond(image.getCreated())).build();
    }

    ImageData(@NonNull Instant createdAt) {
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        this.createdAt = createdAt;
    }

    public static ImageDataBuilder builder() {
        return new ImageDataBuilder();
    }

    @NonNull
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageData)) {
            return false;
        }
        ImageData other = (ImageData)o;
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "ImageData(createdAt=" + this.getCreatedAt() + ")";
    }

    public static class ImageDataBuilder {
        private Instant createdAt;

        ImageDataBuilder() {
        }

        public ImageDataBuilder createdAt(@NonNull Instant createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
            return this;
        }

        public ImageData build() {
            return new ImageData(this.createdAt);
        }

        public String toString() {
            return "ImageData.ImageDataBuilder(createdAt=" + this.createdAt + ")";
        }
    }
}

