/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.server;

import io.micronaut.core.annotation.Internal;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.testresources.server.InjectableTestResourcesResolver;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
@Singleton
public class InternalTestResourcesServiceResolver
implements InjectableTestResourcesResolver {
    public static final String SERVER_URI = "micronaut.test.resources.server.uri";
    private final EmbeddedServer server;

    public InternalTestResourcesServiceResolver(EmbeddedServer server) {
        this.server = server;
    }

    @Override
    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return List.of(SERVER_URI);
    }

    @Override
    public Optional<String> resolve(String propertyName, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        if (SERVER_URI.equals(propertyName)) {
            return Optional.of(this.server.getURI().toString());
        }
        return Optional.empty();
    }
}

