/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.embedded;

import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.testresources.core.ResolverLoader;
import io.micronaut.testresources.core.TestResourcesResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestResourcesResolverLoader
implements ResolverLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestResourcesResolverLoader.class);
    private final List<TestResourcesResolver> resolvers;

    public TestResourcesResolverLoader() {
        SoftServiceLoader<TestResourcesResolver> loader = SoftServiceLoader.load(TestResourcesResolver.class);
        List<Object> values = new ArrayList();
        loader.collectAll(values);
        values = values.stream().collect(Collectors.groupingBy(Object::getClass)).values().stream().map(list -> (TestResourcesResolver)list.get(0)).toList();
        this.resolvers = OrderUtil.sort(values.stream()).toList();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loaded {} test resources resolvers: {}", (Object)this.resolvers.size(), (Object)this.resolvers.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining(", ")));
        }
    }

    @Override
    public List<TestResourcesResolver> getResolvers() {
        return this.resolvers;
    }

    public static TestResourcesResolverLoader getInstance() {
        return Initializer.INSTANCE;
    }

    private static class Initializer {
        private static final TestResourcesResolverLoader INSTANCE = new TestResourcesResolverLoader();

        private Initializer() {
        }
    }
}

