/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.core;

import io.micronaut.core.value.PropertyResolver;
import io.micronaut.testresources.core.TestResourcesResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyResolverSupport {
    public static Map<String, Object> resolveRequiredProperties(String expression, PropertyResolver propertyResolver, TestResourcesResolver testResourcesResolver) {
        List<String> requiredProperties = testResourcesResolver.getRequiredProperties(expression);
        HashMap props = new HashMap(requiredProperties.size() + 1);
        propertyResolver.getProperty("micronaut.test.resources.scope", String.class).ifPresent(scope -> props.put("micronaut.test.resources.scope", scope));
        for (String property : requiredProperties) {
            propertyResolver.getProperty(property, Object.class).ifPresent(value -> props.put(property, value));
        }
        return Collections.unmodifiableMap(props);
    }

    public static boolean canResolveExpression(PropertyResolver propertyResolver, TestResourcesResolver testResourcesResolver, String expression, Map<String, Object> testProperties) {
        List<String> requiredProperties = testResourcesResolver.getRequiredPropertyEntries();
        HashMap<String, Collection<String>> props = new HashMap<String, Collection<String>>(requiredProperties.size());
        for (String property : requiredProperties) {
            Collection<String> entries = propertyResolver.getPropertyEntries(property);
            props.put(property, entries);
        }
        return testResourcesResolver.getResolvableProperties(props, testProperties).contains(expression);
    }
}

