/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.support.util.SubtypeInfo;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

@Internal
public final class SerdeArgumentConf {
    @Nullable
    private final String prefix;
    @Nullable
    private final String suffix;
    @Nullable
    private final String[] ignored;
    @Nullable
    private final String[] included;
    @Nullable
    private final String[] order;
    @Nullable
    private final SubtypeInfo subtypeInfo;

    public SerdeArgumentConf(AnnotationMetadata annotationMetadata) {
        this.prefix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "prefix").orElse(null);
        this.suffix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "suffix").orElse(null);
        String[] ignored = null;
        String[] included = null;
        String[] order = null;
        if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerIgnored.class) && (ignored = annotationMetadata.stringValues(SerdeConfig.SerIgnored.class)).length == 0) {
            ignored = null;
        }
        this.ignored = ignored;
        if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerIncluded.class) && (included = annotationMetadata.stringValues(SerdeConfig.SerIncluded.class)).length == 0) {
            included = null;
        }
        this.included = included;
        if (annotationMetadata.isAnnotationPresent("PropertyOrder") && (order = annotationMetadata.stringValues("PropertyOrder")).length == 0) {
            order = null;
        }
        this.order = order;
        this.subtypeInfo = SubtypeInfo.createForProperty(annotationMetadata);
    }

    public String applyPrefixSuffix(String name) {
        if (this.prefix != null) {
            name = this.prefix + (String)name;
        }
        if (this.suffix != null) {
            name = (String)name + this.suffix;
        }
        return name;
    }

    public <Z> Argument<Z> extendArgumentWithPrefixSuffix(Argument<Z> argument) {
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        if (annotationMetadata.isEmpty()) {
            return argument;
        }
        String extraPrefix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "prefix").orElse(null);
        String extraSuffix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "suffix").orElse(null);
        if (this.prefix == null && this.suffix == null) {
            return argument;
        }
        if (this.prefix != null) {
            String string = extraPrefix = extraPrefix == null ? this.prefix : this.prefix + extraPrefix;
        }
        if (this.suffix != null) {
            extraSuffix = extraSuffix == null ? this.suffix : extraSuffix + this.suffix;
        }
        MutableAnnotationMetadata mutableAnnotationMetadata = new MutableAnnotationMetadata();
        LinkedHashMap<CharSequence, Object> newValues = new LinkedHashMap<CharSequence, Object>();
        if (extraPrefix != null) {
            newValues.put("prefix", extraPrefix);
        }
        if (extraSuffix != null) {
            newValues.put("suffix", extraSuffix);
        }
        mutableAnnotationMetadata.addDeclaredAnnotation(SerdeConfig.SerUnwrapped.class.getName(), newValues);
        return Argument.of(argument.getType(), argument.getName(), new AnnotationMetadataHierarchy(argument.getAnnotationMetadata(), mutableAnnotationMetadata), argument.getTypeParameters());
    }

    @Nullable
    public Predicate<String> resolveAllowPropertyPredicate(boolean allowIgnoredProperties) {
        Set<String> includedSet;
        Set<String> ignoreSet = this.ignored != null && !allowIgnoredProperties ? CollectionUtils.setOf(this.ignored) : null;
        Set<String> set = includedSet = this.included != null ? CollectionUtils.setOf(this.included) : null;
        if (ignoreSet != null || includedSet != null) {
            return propertyName -> {
                if (ignoreSet != null && ignoreSet.contains(propertyName)) {
                    return false;
                }
                return includedSet == null || includedSet.contains(propertyName);
            };
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerdeArgumentConf that = (SerdeArgumentConf)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.suffix, that.suffix) && Arrays.equals(this.ignored, that.ignored) && Arrays.equals(this.included, that.included) && Arrays.equals(this.order, that.order) && Objects.equals(this.subtypeInfo, that.subtypeInfo);
    }

    public int hashCode() {
        int result = Objects.hash(this.prefix, this.suffix, this.subtypeInfo);
        result = 31 * result + Arrays.hashCode(this.ignored);
        result = 31 * result + Arrays.hashCode(this.included);
        result = 31 * result + Arrays.hashCode(this.order);
        return result;
    }

    @Nullable
    public String[] order() {
        return this.order;
    }

    @Nullable
    public String[] getIgnored() {
        return this.ignored;
    }

    @Nullable
    public String[] getIncluded() {
        return this.included;
    }

    @Nullable
    public SubtypeInfo getSubtypeInfo() {
        return this.subtypeInfo;
    }
}

