/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.support.util.SpreadProcessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.Consumer;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;

@Internal
public abstract class BufferingJsonNodeProcessor
extends SpreadProcessor<byte[], JsonNode> {
    private final Consumer<Processor<byte[], JsonNode>> onSubscribe;
    private final boolean streamArray;
    private final Queue<byte[]> buffers = new ArrayDeque<byte[]>();
    private int headOffset = 0;
    private long buffersState = 0L;
    private boolean onlyWhitespace = true;

    public BufferingJsonNodeProcessor(Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        this.onSubscribe = onSubscribe;
        this.streamArray = streamArray;
    }

    @Override
    public void subscribe(Subscriber<? super JsonNode> s2) {
        this.onSubscribe.accept(this);
        super.subscribe(s2);
    }

    @Override
    protected void spread(byte[] bytes, Collection<JsonNode> out) throws IOException {
        if (bytes.length == 0) {
            return;
        }
        this.buffers.add(bytes);
        for (int i = 0; i < bytes.length; ++i) {
            boolean ws = BufferingJsonNodeProcessor.isJsonWhitespace(bytes[i]);
            boolean wasOutsideStructure = this.buffersState == 0L;
            this.buffersState = BufferingJsonNodeProcessor.walkJson(this.buffersState, bytes[i]);
            if (this.buffersState != 0L && wasOutsideStructure && !this.onlyWhitespace) {
                this.processOne(bytes.length - i, out);
            }
            this.onlyWhitespace &= ws;
            if (this.buffersState != 0L || !ws && wasOutsideStructure || this.onlyWhitespace) continue;
            this.processOne(bytes.length - i, out);
        }
    }

    @Override
    protected void complete(Collection<JsonNode> out) throws IOException {
        if (!this.onlyWhitespace) {
            this.processOne(0, out);
            this.onlyWhitespace = true;
        }
    }

    private void processOne(int tailRemaining, Collection<JsonNode> out) throws IOException {
        int totalLength = -this.headOffset - tailRemaining;
        for (byte[] buffer : this.buffers) {
            totalLength += buffer.length;
        }
        byte[] composite = new byte[totalLength];
        int compositeOff = 0;
        boolean head = true;
        byte[] tailBuffer = null;
        Iterator iterator = this.buffers.iterator();
        while (iterator.hasNext()) {
            boolean tail;
            byte[] buffer = (byte[])iterator.next();
            boolean bl = tail = !iterator.hasNext();
            if (tail) {
                tailBuffer = buffer;
            }
            int bufferOff = head ? this.headOffset : 0;
            int bufferLen = buffer.length - bufferOff - (tail ? tailRemaining : 0);
            System.arraycopy(buffer, bufferOff, composite, compositeOff, bufferLen);
            compositeOff += bufferLen;
            head = false;
        }
        this.processTopLevelNode(this.parseOne(composite), out);
        this.buffers.clear();
        if (tailBuffer != null && tailRemaining != 0) {
            this.buffers.add(tailBuffer);
            this.headOffset = tailBuffer.length - tailRemaining;
        } else {
            this.headOffset = 0;
        }
        this.onlyWhitespace = true;
    }

    private void processTopLevelNode(JsonNode node, Collection<JsonNode> out) {
        if (this.streamArray && node.isArray()) {
            for (JsonNode child : node.values()) {
                out.add(child);
            }
        } else {
            out.add(node);
        }
    }

    @NonNull
    protected abstract JsonNode parseOne(@NonNull InputStream var1) throws IOException;

    @NonNull
    protected JsonNode parseOne(@NonNull byte[] remaining) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(remaining);){
            JsonNode jsonNode = this.parseOne(is);
            return jsonNode;
        }
    }

    private static boolean isJsonWhitespace(byte b) {
        return b == 32 || b == 10 || b == 13 || b == 9;
    }

    static long walkJson(long state, byte b) {
        int dfaState = (int)state;
        int nestCount = (int)(state >> 32);
        block0 : switch (dfaState) {
            case 0: {
                switch (b) {
                    case 34: {
                        dfaState = 1;
                        break block0;
                    }
                    case 91: 
                    case 123: {
                        ++nestCount;
                        break block0;
                    }
                    case 93: 
                    case 125: {
                        --nestCount;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (b) {
                    case 34: {
                        dfaState = 0;
                        break block0;
                    }
                    case 92: {
                        dfaState = 2;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                dfaState = 1;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return (long)nestCount << 32 | (long)dfaState;
    }
}

