/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.UUID;

@Internal
final class UUIDSerde
implements SerdeRegistrar<UUID> {
    UUIDSerde() {
    }

    @Override
    public Argument<UUID> getType() {
        return Argument.of(UUID.class);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends UUID> type, UUID value) throws IOException {
        encoder.encodeString(value.toString());
    }

    @Override
    public UUID deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super UUID> type) throws IOException {
        return UUID.fromString(decoder.decodeString());
    }

    @Override
    public UUID deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super UUID> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }
}

