/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.InstantSerde;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;

final class SqlTimestampSerde
implements SerdeRegistrar<Timestamp> {
    private static final Argument<Instant> INSTANT_ARGUMENT = Argument.of(Instant.class);
    private final InstantSerde instantSerde;

    SqlTimestampSerde(InstantSerde instantSerde) {
        this.instantSerde = instantSerde;
    }

    @Override
    public Serializer<Timestamp> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Timestamp> type) {
        Argument<Instant> argument = Argument.of(Instant.class, type.getAnnotationMetadata(), new Argument[0]);
        Serializer<Instant> specific = this.instantSerde.createSpecific(encoderContext, argument);
        if (specific != this.instantSerde) {
            return (encoder, context, t2, value) -> specific.serialize(encoder, context, argument, value.toInstant());
        }
        return this;
    }

    @Override
    public Deserializer<Timestamp> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Timestamp> context) throws SerdeException {
        Argument<Instant> argument = Argument.of(Instant.class, context.getAnnotationMetadata(), new Argument[0]);
        Deserializer<Instant> specific = this.instantSerde.createSpecific(decoderContext, argument);
        if (specific != this.instantSerde) {
            return (decoder, subContext, type) -> {
                Instant i = (Instant)specific.deserialize(decoder, subContext, argument);
                if (i != null) {
                    return Timestamp.from(i);
                }
                return null;
            };
        }
        return this;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Timestamp> type, Timestamp value) throws IOException {
        this.instantSerde.serialize(encoder, context, INSTANT_ARGUMENT, value.toInstant());
    }

    @Override
    public Timestamp deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Timestamp> type) throws IOException {
        return Timestamp.from((Instant)this.instantSerde.deserialize(decoder, decoderContext, INSTANT_ARGUMENT));
    }

    @Override
    public Argument<Timestamp> getType() {
        return Argument.of(Timestamp.class);
    }
}

