/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.OptionalDouble;

@Internal
final class OptionalDoubleSerde
implements SerdeRegistrar<OptionalDouble> {
    OptionalDoubleSerde() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalDouble> type, OptionalDouble value) throws IOException {
        if (value.isPresent()) {
            encoder.encodeDouble(value.getAsDouble());
        } else {
            encoder.encodeNull();
        }
    }

    @Override
    public OptionalDouble deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super OptionalDouble> type) throws IOException {
        if (decoder.decodeNull()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(decoder.decodeDouble());
    }

    @Override
    public OptionalDouble deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super OptionalDouble> type) throws IOException {
        return this.deserialize(decoder, context, (Argument)type);
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, OptionalDouble value) {
        return value == null || value.isEmpty();
    }

    @Override
    public boolean isAbsent(Serializer.EncoderContext context, OptionalDouble value) {
        return value == null || value.isEmpty();
    }

    @Override
    public OptionalDouble getDefaultValue(Deserializer.DecoderContext context, Argument<? super OptionalDouble> type) {
        return OptionalDouble.empty();
    }

    @Override
    public Argument<OptionalDouble> getType() {
        return Argument.of(OptionalDouble.class);
    }
}

