/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

@Internal
final class FormattedNumberSerde<N extends Number>
implements Serde<N> {
    private final String pattern;
    private final Locale locale;

    FormattedNumberSerde(@NonNull String pattern, @NonNull AnnotationMetadata annotationMetadata) {
        this.pattern = pattern;
        this.locale = annotationMetadata.stringValue(SerdeConfig.class, "locale").map(StringUtils::parseLocale).orElse(null);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends N> type, N value) throws IOException {
        DecimalFormat decimalFormat = this.createDecimalFormat(type);
        String result = decimalFormat.format(value);
        encoder.encodeString(result);
    }

    @Override
    public N deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super N> type) throws IOException {
        String s2 = decoder.decodeString();
        DecimalFormat decimalFormat = this.createDecimalFormat(type);
        try {
            Number number = decimalFormat.parse(s2);
            return (N)((Number)decoderContext.getConversionService().convertRequired((Object)number, type));
        }
        catch (Exception e) {
            throw new SerdeException("Error decoding number of type " + type + " using pattern " + this.pattern + ":" + e.getMessage(), e);
        }
    }

    private DecimalFormat createDecimalFormat(Argument<?> type) throws SerdeException {
        DecimalFormat decimalFormat;
        try {
            if (this.locale != null) {
                decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.locale);
                decimalFormat.applyPattern(this.pattern);
            } else {
                decimalFormat = new DecimalFormat(this.pattern);
            }
        }
        catch (Exception e) {
            throw new SerdeException("Error decoding number of type " + type + ", pattern is invalid " + this.pattern + ":" + e.getMessage(), e);
        }
        return decimalFormat;
    }
}

