/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.NumberSerde;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class FloatSerde
implements SerdeRegistrar<Float>,
NumberSerde<Float> {
    FloatSerde() {
    }

    @Override
    public Float deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Float> type) throws IOException {
        return Float.valueOf(decoder.decodeFloat());
    }

    @Override
    public Float deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Float> type) throws IOException {
        return decoder.decodeFloatNullable();
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Float> type, Float value) throws IOException {
        encoder.encodeFloat(value.floatValue());
    }

    @Override
    public Argument<Float> getType() {
        return Argument.of(Float.class);
    }

    @Override
    public Iterable<Argument<?>> getTypes() {
        return Arrays.asList(this.getType(), Argument.FLOAT);
    }

    @Override
    @Nullable
    public Float getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Float> type) {
        return type.isPrimitive() ? Float.valueOf(0.0f) : null;
    }
}

