/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class DoubleArraySerde
implements SerdeRegistrar<double[]> {
    DoubleArraySerde() {
    }

    @Override
    public double[] deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super double[]> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        double[] buffer = new double[50];
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            if (buffer.length == index) {
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            if (!arrayDecoder.decodeNull()) {
                buffer[index] = arrayDecoder.decodeDouble();
            }
            ++index;
        }
        arrayDecoder.finishStructure();
        return Arrays.copyOf(buffer, index);
    }

    @Override
    public double[] deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super double[]> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends double[]> type, double[] value) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        for (double i : value) {
            arrayEncoder.encodeDouble(i);
        }
        arrayEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, double[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public Argument<double[]> getType() {
        return Argument.of(double[].class);
    }
}

