/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.deserializers.collect.CollectionDeserializer;
import java.io.IOException;
import java.util.ArrayList;

@Internal
final class ArrayListDeserializer<E>
extends CollectionDeserializer<E, ArrayList<E>> {
    ArrayListDeserializer(Deserializer<? extends E> valueDeser, Argument<E> collectionItemArgument) {
        super(valueDeser, collectionItemArgument);
    }

    @Override
    public ArrayList<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super ArrayList<E>> type) throws IOException {
        ArrayList collection = new ArrayList();
        this.doDeserialize(decoder, context, collection);
        return collection;
    }

    @Override
    public ArrayList<E> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super ArrayList<E>> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }

    @Override
    public ArrayList<E> getDefaultValue(Deserializer.DecoderContext context, Argument<? super ArrayList<E>> type) {
        return new ArrayList();
    }
}

