/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.AbstractPropertyReferenceManager;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.support.DefaultSerdeRegistry;
import java.util.Collection;
import java.util.Optional;

@Internal
class DefaultDecoderContext
extends AbstractPropertyReferenceManager
implements Deserializer.DecoderContext {
    private final DefaultSerdeRegistry registry;

    DefaultDecoderContext(DefaultSerdeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public final ConversionService getConversionService() {
        return this.registry.getConversionService();
    }

    @Override
    public final <T, D extends Deserializer<? extends T>> D findCustomDeserializer(Class<? extends D> deserializerClass) throws SerdeException {
        return this.registry.findCustomDeserializer(deserializerClass);
    }

    @Override
    public final <T> Deserializer<? extends T> findDeserializer(Argument<? extends T> type) throws SerdeException {
        return this.registry.findDeserializer(type);
    }

    @Override
    public <D extends PropertyNamingStrategy> D findNamingStrategy(Class<? extends D> namingStrategyClass) throws SerdeException {
        return this.registry.findNamingStrategy(namingStrategyClass);
    }

    @Override
    public final <T> Collection<BeanIntrospection<? extends T>> getDeserializableSubtypes(Class<T> superType) {
        return this.registry.getDeserializableSubtypes(superType);
    }

    @Override
    public <B, P> PropertyReference<B, P> resolveReference(PropertyReference<B, P> reference) {
        if (this.refs != null) {
            for (PropertyReference ref : this.refs) {
                Object o;
                if (!ref.getReferenceName().equals(reference.getProperty().getName()) || (o = ref.getReference()) == null) continue;
                return ref;
            }
        }
        return reference;
    }

    @Override
    public Optional<SerdeConfiguration> getSerdeConfiguration() {
        return Optional.of(this.registry.getSerdeConfiguration());
    }

    @Override
    public Optional<DeserializationConfiguration> getDeserializationConfiguration() {
        return Optional.of(this.registry.getDeserializationConfiguration());
    }
}

