/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context.scope.refresh;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.env.Environment;
import java.util.Arrays;
import java.util.Set;

public class RefreshScopeCondition
implements Condition {
    private static final String[] DISABLED_ENVIRONMENTS = new String[]{"function", "android"};

    @Override
    public boolean matches(ConditionContext context) {
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            Environment environment = applicationContext.getEnvironment();
            Set<String> activeNames = environment.getActiveNames();
            boolean disabledEnvironment = Arrays.stream(DISABLED_ENVIRONMENTS).anyMatch(activeNames::contains);
            boolean isUnderTest = activeNames.contains("test");
            if (disabledEnvironment && !isUnderTest) {
                context.fail("Refresh scope is disabled for function and android environments when not under test.");
                return false;
            }
        }
        return true;
    }
}

