/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context.env;

import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DefaultBeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.env.ConfigurationPath;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.value.PropertyNotFoundException;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.runtime.context.env.ConfigurationAdvice;
import java.util.Collections;
import java.util.Optional;

@Prototype
@Internal
@BootstrapContextCompatible
@InterceptorBean(value={ConfigurationAdvice.class})
public class ConfigurationIntroductionAdvice
implements MethodInterceptor<Object, Object> {
    private static final String MEMBER_BEAN = "bean";
    private static final String MEMBER_NAME = "name";
    private final Environment environment;
    private final BeanContext beanContext;
    private final ConfigurationPath configurationPath;
    private final BeanDefinition<?> beanDefinition;

    ConfigurationIntroductionAdvice(BeanResolutionContext resolutionContext, Environment environment, BeanContext beanContext) {
        this.beanDefinition = resolutionContext.getRootDefinition();
        this.environment = environment;
        this.beanContext = beanContext;
        this.configurationPath = resolutionContext.getConfigurationPath().copy();
    }

    @Override
    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        ReturnType<Object> rt = context.getReturnType();
        Class<Object> returnType = rt.getType();
        Argument<Object> argument = rt.asArgument();
        if (context.isTrue(ConfigurationAdvice.class, MEMBER_BEAN)) {
            return this.resolveBean(context, returnType, argument);
        }
        return this.resolveProperty(context, rt, argument);
    }

    private Object resolveProperty(MethodInvocationContext<Object, Object> context, ReturnType<Object> rt, Argument<Object> argument) {
        String property = context.stringValue(Property.class, MEMBER_NAME).orElse(null);
        if (property == null) {
            throw new IllegalStateException("No property name available to resolve");
        }
        if (this.configurationPath.hasDynamicSegments()) {
            property = this.configurationPath.resolveValue(property);
        }
        String defaultValue = context.stringValue(Bindable.class, "defaultValue").orElse(null);
        Optional<Object> value = this.environment.getProperty(property, argument);
        if (defaultValue != null) {
            Object result = value.orElse(null);
            if (result == null) {
                return this.environment.convertRequired((Object)defaultValue, argument);
            }
            return result;
        }
        if (rt.isOptional()) {
            return value.orElse(Optional.empty());
        }
        if (context.isNullable()) {
            return value.orElse(null);
        }
        String finalProperty = property;
        return value.orElseThrow(() -> new PropertyNotFoundException(finalProperty, argument.getType()));
    }

    private Object resolveBean(MethodInvocationContext<Object, Object> context, Class<Object> returnType, Argument<Object> argument) {
        Qualifier qualifier = this.configurationPath.beanQualifier();
        if (Iterable.class.isAssignableFrom(returnType)) {
            Argument firstArg = argument.getFirstTypeVariable().orElse(null);
            if (firstArg != null) {
                return this.environment.convertRequired(this.beanContext.getBeansOfType(firstArg, qualifier), argument);
            }
            return this.environment.convertRequired(Collections.emptyMap(), argument);
        }
        if (context.isNullable()) {
            Object v = this.beanContext.findBean(argument, qualifier).orElse(null);
            if (v != null) {
                return this.environment.convertRequired(v, returnType);
            }
            return v;
        }
        try (DefaultBeanResolutionContext rc = new DefaultBeanResolutionContext(this.beanContext, this.beanDefinition);){
            rc.setConfigurationPath(this.configurationPath);
            Object object = this.environment.convertRequired(((DefaultBeanContext)this.beanContext).getBean((BeanResolutionContext)rc, argument, qualifier), returnType);
            return object;
        }
    }
}

