/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.aggregator;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.endpoint.health.HealthLevelOfDetail;
import io.micronaut.management.health.aggregator.HealthAggregator;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Requires(beans={HealthEndpoint.class})
public class DefaultHealthAggregator
implements HealthAggregator<HealthResult> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHealthAggregator.class);
    private final ApplicationConfiguration applicationConfiguration;

    public DefaultHealthAggregator(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    public Publisher<HealthResult> aggregate(HealthIndicator[] indicators, HealthLevelOfDetail healthLevelOfDetail) {
        Flux<HealthResult> results = this.aggregateResults(indicators);
        Mono<HealthResult> result = results.collectList().map(list -> {
            HealthStatus overallStatus = this.calculateOverallStatus((List<HealthResult>)list);
            return this.buildResult(overallStatus, this.aggregateDetails((List<HealthResult>)list), healthLevelOfDetail);
        });
        return result.flux();
    }

    @Override
    public Publisher<HealthResult> aggregate(String name, Publisher<HealthResult> results) {
        Mono<HealthResult> result = Flux.from(results).collectList().map(list -> {
            HealthStatus overallStatus = this.calculateOverallStatus((List<HealthResult>)list);
            Object details = this.aggregateDetails((List<HealthResult>)list);
            return HealthResult.builder(name, overallStatus).details(details).build();
        });
        return result.flux();
    }

    protected HealthStatus calculateOverallStatus(List<HealthResult> results) {
        return results.stream().map(HealthResult::getStatus).sorted().distinct().reduce((a, b) -> b).orElse(HealthStatus.UNKNOWN);
    }

    protected Flux<HealthResult> aggregateResults(HealthIndicator[] indicators) {
        return Flux.merge(Arrays.stream(indicators).map(HealthIndicator::getResult).collect(Collectors.toList()));
    }

    protected Object aggregateDetails(List<HealthResult> results) {
        HashMap aggregatedDetails = CollectionUtils.newHashMap(results.size());
        results.forEach(r -> {
            String name = r.getName();
            Object details = r.getDetails();
            HealthStatus status = r.getStatus();
            aggregatedDetails.put(name, this.buildResult(status, details, HealthLevelOfDetail.STATUS_DESCRIPTION_DETAILS));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Health result for {}: status {}, details {}", name, status, details != null ? details : "{}");
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Health result for {}: status {}", (Object)name, (Object)status);
            }
        });
        return aggregatedDetails;
    }

    protected HealthResult buildResult(HealthStatus status, Object details, HealthLevelOfDetail healthLevelOfDetail) {
        if (healthLevelOfDetail == HealthLevelOfDetail.STATUS) {
            return HealthResult.builder(null, status).build();
        }
        return HealthResult.builder(this.applicationConfiguration.getName().orElse("application"), status).details(details).build();
    }
}

