/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.ssl;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public abstract class SslBuilder<T> {
    private final ResourceResolver resourceResolver;

    public SslBuilder(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public abstract Optional<T> build(SslConfiguration var1);

    public abstract Optional<T> build(SslConfiguration var1, HttpVersion var2);

    @Nullable
    protected TrustManagerFactory getTrustManagerFactory(SslConfiguration ssl) {
        try {
            Optional<KeyStore> store = this.getTrustStore(ssl);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)store.orElse(null));
            return trustManagerFactory;
        }
        catch (Exception ex) {
            throw new SslConfigurationException(ex);
        }
    }

    protected Optional<KeyStore> getTrustStore(SslConfiguration ssl) throws Exception {
        SslConfiguration.TrustStoreConfiguration trustStore = ssl.getTrustStore();
        Optional<String> path = trustStore.getPath();
        if (path.isPresent()) {
            return Optional.of(this.load(trustStore.getType(), path.get(), trustStore.getPassword()));
        }
        return Optional.empty();
    }

    protected KeyManagerFactory getKeyManagerFactory(SslConfiguration ssl) {
        try {
            Optional<KeyStore> keyStore = this.getKeyStore(ssl);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            Optional<String> password = ssl.getKey().getPassword();
            char[] keyPassword = password.map(String::toCharArray).orElse(null);
            Optional<String> pwd = ssl.getKeyStore().getPassword();
            if (keyPassword == null && pwd.isPresent()) {
                keyPassword = pwd.get().toCharArray();
            }
            keyManagerFactory.init(keyStore.orElse(null), keyPassword);
            return keyManagerFactory;
        }
        catch (Exception ex) {
            throw new SslConfigurationException(ex);
        }
    }

    protected Optional<KeyStore> getKeyStore(SslConfiguration ssl) throws Exception {
        SslConfiguration.KeyStoreConfiguration keyStore = ssl.getKeyStore();
        Optional<String> path = keyStore.getPath();
        if (path.isPresent()) {
            return Optional.of(this.load(keyStore.getType(), path.get(), keyStore.getPassword()));
        }
        return Optional.empty();
    }

    protected KeyStore load(Optional<String> optionalType, String resource, Optional<String> optionalPassword) throws Exception {
        String type = optionalType.orElse("JKS");
        String password = optionalPassword.orElse(null);
        KeyStore store = KeyStore.getInstance(type);
        Optional<URL> url = this.resourceResolver.getResource(resource);
        if (url.isPresent()) {
            store.load(url.get().openStream(), password == null ? null : password.toCharArray());
            return store;
        }
        throw new SslConfigurationException("The resource " + resource + " could not be found");
    }
}

