/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentSubscriberFactory;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.jackson.JsonContentProcessor;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;

@Consumes(value={"application/x-json-stream", "application/json"})
@Singleton
@Internal
public class JsonHttpContentSubscriberFactory
implements HttpContentSubscriberFactory {
    private final NettyHttpServerConfiguration httpServerConfiguration;
    private final JsonMapper jsonMapper;

    public JsonHttpContentSubscriberFactory(JsonMapper jsonMapper, NettyHttpServerConfiguration httpServerConfiguration) {
        this.httpServerConfiguration = httpServerConfiguration;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public HttpContentProcessor build(NettyHttpRequest request) {
        return new JsonContentProcessor(request, this.httpServerConfiguration, this.jsonMapper);
    }
}

