/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.server.cors.CorsFilter;
import io.micronaut.http.server.cors.CorsUtil;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRouteMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Requires(property="micronaut.server.dispatch-options-requests", value="true", defaultValue="false")
@ServerFilter(value={"/**"})
@Internal
public final class OptionsFilter
implements Ordered {
    public static final String PREFIX = "micronaut.server.dispatch-options-requests";

    @ResponseFilter
    @Nullable
    @Internal
    public HttpResponse<?> filterResponse(HttpRequest<?> request, MutableHttpResponse<?> response) {
        if (request.getMethod() != HttpMethod.OPTIONS) {
            return null;
        }
        if (CorsUtil.isPreflightRequest(request)) {
            return null;
        }
        if (this.hasOptionsRouteMatch(request)) {
            return null;
        }
        if (HttpStatus.METHOD_NOT_ALLOWED.equals(response.getStatus())) {
            List allowedMethods = response.getHeaders().get("Allow", String[].class).map(allow -> new ArrayList<String>(Arrays.asList(allow))).orElse(new ArrayList());
            allowedMethods.add(HttpMethod.OPTIONS.toString());
            response.getHeaders().remove("Allow");
            response.getHeaders().allowGeneric(allowedMethods);
            response.status(HttpStatus.OK);
        }
        return response;
    }

    private boolean hasOptionsRouteMatch(HttpRequest<?> request) {
        return request.getAttribute(HttpAttributes.ROUTE_MATCH, RouteMatch.class).map(routeMatch -> {
            if (routeMatch instanceof UriRouteMatch) {
                UriRouteMatch uriRouteMatch = (UriRouteMatch)routeMatch;
                return uriRouteMatch.getHttpMethod() == HttpMethod.OPTIONS;
            }
            return true;
        }).orElse(false);
    }

    @Override
    public int getOrder() {
        return CorsFilter.CORS_FILTER_ORDER + 10;
    }
}

