/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.netty.body.CustomizableNettyJsonHandler;
import io.micronaut.http.netty.body.JsonChunkedProcessor;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.body.JsonMessageHandler;
import io.netty.buffer.ByteBuf;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
@Singleton
@Produces(value={"application/x-json-stream"})
@Consumes(value={"application/x-json-stream"})
public final class NettyJsonStreamHandler<T>
implements MessageBodyHandler<T>,
ChunkedMessageBodyReader<T>,
CustomizableNettyJsonHandler {
    private final JsonMessageHandler<T> jsonMessageHandler;

    public NettyJsonStreamHandler(JsonMapper jsonMapper) {
        this(new JsonMessageHandler(jsonMapper));
    }

    private NettyJsonStreamHandler(JsonMessageHandler<T> jsonMessageHandler) {
        this.jsonMessageHandler = jsonMessageHandler;
    }

    @Override
    public CustomizableNettyJsonHandler customize(JsonFeatures jsonFeatures) {
        return new NettyJsonStreamHandler<T>(this.jsonMessageHandler.getJsonMapper().cloneWithFeatures(jsonFeatures));
    }

    @Override
    public boolean isReadable(Argument<T> type, MediaType mediaType) {
        return mediaType.matches(MediaType.APPLICATION_JSON_STREAM_TYPE);
    }

    @Override
    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        if (!type.getType().isAssignableFrom(List.class)) {
            throw new IllegalArgumentException("Can only read json-stream to a Publisher or list type");
        }
        return (T)((Flux)this.readChunked((Argument)type.getFirstTypeVariable().orElse(type), mediaType, httpHeaders, Flux.just(byteBuffer))).collectList().block();
    }

    @Override
    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        throw new UnsupportedOperationException("Reading from InputStram is not supported for json-stream");
    }

    @Override
    public Flux<T> readChunked(Argument<T> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        JsonChunkedProcessor processor = new JsonChunkedProcessor();
        return processor.process(Flux.from(input).map(bb -> {
            Object patt3681$temp = bb.asNativeBuffer();
            if (!(patt3681$temp instanceof ByteBuf)) {
                throw new IllegalArgumentException("Only netty buffers are supported");
            }
            ByteBuf buf = (ByteBuf)patt3681$temp;
            return buf;
        })).map(bb -> this.jsonMessageHandler.read(type, mediaType, httpHeaders, (ByteBuffer<?>)bb));
    }

    @Override
    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        this.jsonMessageHandler.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }

    @Override
    public ByteBuffer<?> writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        return this.jsonMessageHandler.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
    }
}

