/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@Internal
final class MappedPendingRequestBindingResult<T, R>
implements PendingRequestBindingResult<R> {
    private final PendingRequestBindingResult<T> source;
    private final Function<T, ArgumentBinder.BindingResult<R>> function;
    private ArgumentBinder.BindingResult<R> second;

    MappedPendingRequestBindingResult(PendingRequestBindingResult<T> source, Function<T, ArgumentBinder.BindingResult<R>> function) {
        this.source = source;
        this.function = function;
    }

    private ArgumentBinder.BindingResult<R> computeSecond() {
        if (this.second == null) {
            Optional first = this.source.getValue();
            this.second = first.isPresent() ? this.function.apply(first.get()) : this.source;
        }
        return this.second;
    }

    @Override
    public List<ConversionError> getConversionErrors() {
        List<ConversionError> conversionErrors = this.source.getConversionErrors();
        if (conversionErrors.isEmpty() && this.source.isSatisfied()) {
            conversionErrors = this.computeSecond().getConversionErrors();
        }
        return conversionErrors;
    }

    @Override
    public boolean isSatisfied() {
        return this.source.isSatisfied() && this.computeSecond().isSatisfied();
    }

    @Override
    public Optional<R> getValue() {
        return this.computeSecond().getValue();
    }

    @Override
    public boolean isPending() {
        return this.source.isPending();
    }
}

