/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.graal.GraalReflectionConfigurer;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.service.ServiceScanner;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.exception.InstantiationException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

final class ServiceLoaderFeature
implements Feature {
    ServiceLoaderFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.configureForReflection(access);
        ServiceScanner.StaticServiceDefinitions staticServiceDefinitions = this.buildStaticServiceDefinitions(access);
        Collection<Set<String>> allTypeNames = staticServiceDefinitions.serviceTypeMap().values();
        for (Set<String> typeNameSet : allTypeNames) {
            Iterator<String> i = typeNameSet.iterator();
            while (i.hasNext()) {
                String typeName = i.next();
                try {
                    Class c = access.findClassByName(typeName);
                    if (c != null) {
                        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{c});
                        RuntimeReflection.register((Class[])new Class[]{c});
                        continue;
                    }
                    i.remove();
                }
                catch (InstantiationException | NoClassDefFoundError e) {
                    i.remove();
                }
            }
        }
        ImageSingletons.add(ServiceScanner.StaticServiceDefinitions.class, (Object)staticServiceDefinitions);
    }

    @NonNull
    private ServiceScanner.StaticServiceDefinitions buildStaticServiceDefinitions(Feature.BeforeAnalysisAccess access) {
        ServiceScanner.StaticServiceDefinitions staticServiceDefinitions = new ServiceScanner.StaticServiceDefinitions(null);
        String path = "META-INF/micronaut/";
        try {
            Enumeration<URL> micronautResources = access.getApplicationClassLoader().getResources("META-INF/micronaut/");
            while (micronautResources.hasMoreElements()) {
                HashSet servicePaths = new HashSet();
                URL url = micronautResources.nextElement();
                URI uri = url.toURI();
                boolean isFileScheme = "file".equals(uri.getScheme());
                if (isFileScheme) {
                    Path p = Paths.get(uri);
                    uri = p.getParent().getParent().toUri();
                }
                IOUtils.eachFile(uri, "META-INF/micronaut/", servicePath -> {
                    if (Files.isDirectory(servicePath, new LinkOption[0])) {
                        String serviceName = servicePath.toString();
                        if (isFileScheme) {
                            int i = serviceName.indexOf("META-INF/micronaut/");
                            if (i > -1) {
                                serviceName = serviceName.substring(i);
                            }
                        } else if (serviceName.startsWith("/")) {
                            serviceName = serviceName.substring(1);
                        }
                        if (serviceName.startsWith("META-INF/micronaut/")) {
                            servicePaths.add(serviceName);
                        }
                    }
                });
                for (String servicePath2 : servicePaths) {
                    IOUtils.eachFile(uri, servicePath2, serviceTypePath -> {
                        if (Files.isRegularFile(serviceTypePath, new LinkOption[0])) {
                            Set serviceTypeNames = staticServiceDefinitions.serviceTypeMap().computeIfAbsent(servicePath2, key -> new HashSet());
                            String serviceTypeName = serviceTypePath.getFileName().toString();
                            serviceTypeNames.add(serviceTypeName);
                        }
                    });
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return staticServiceDefinitions;
    }

    private void configureForReflection(final Feature.BeforeAnalysisAccess access) {
        ArrayList configurers = new ArrayList();
        SoftServiceLoader.load(GraalReflectionConfigurer.class, access.getApplicationClassLoader()).collectAll(configurers);
        GraalReflectionConfigurer.ReflectionConfigurationContext context = new GraalReflectionConfigurer.ReflectionConfigurationContext(){

            @Override
            public Class<?> findClassByName(@NonNull String name) {
                return access.findClassByName(name);
            }

            @Override
            public void register(Class<?> ... types) {
                RuntimeReflection.register((Class[])types);
            }

            @Override
            public void register(Method ... methods) {
                RuntimeReflection.register((Executable[])methods);
            }

            @Override
            public void register(Field ... fields) {
                RuntimeReflection.register((Field[])fields);
            }

            @Override
            public void register(Constructor<?> ... constructors) {
                RuntimeReflection.register((Executable[])constructors);
            }
        };
        for (GraalReflectionConfigurer configurer : configurers) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{configurer.getClass()});
            configurer.configure(context);
        }
    }
}

