/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;

public interface BeanContextConfiguration {
    default public boolean isAllowEmptyProviders() {
        return false;
    }

    @NonNull
    default public ClassLoader getClassLoader() {
        return ApplicationContextConfiguration.class.getClassLoader();
    }

    default public boolean isEagerInitSingletons() {
        for (Class<? extends Annotation> ann : this.getEagerInitAnnotated()) {
            if (ann != Singleton.class && !ann.getName().equals("jakarta.inject.Singleton")) continue;
            return true;
        }
        return false;
    }

    default public boolean isEagerInitConfiguration() {
        return this.getEagerInitAnnotated().contains(ConfigurationReader.class);
    }

    default public Set<Class<? extends Annotation>> getEagerInitAnnotated() {
        return Collections.emptySet();
    }
}

