/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.sourcegen.model.AbstractElement;
import io.micronaut.sourcegen.model.AbstractElementBuilder;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class AnnotationObjectDef
extends ObjectDef {
    private final List<AnnotationMemberDef> members;
    private final List<FieldDef> fields;

    private AnnotationObjectDef(List<AnnotationMemberDef> members, List<FieldDef> fields, ClassTypeDef.ClassName className, EnumSet<Modifier> modifiers, List<AnnotationDef> annotations, List<String> javadoc, List<ObjectDef> innerTypes) {
        super(className, modifiers, annotations, javadoc, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), innerTypes, false);
        this.fields = fields;
        this.members = members;
    }

    @Override
    public ObjectDef withClassName(ClassTypeDef.ClassName className) {
        return new AnnotationObjectDef(this.members, this.fields, className, this.modifiers, this.annotations, this.javadoc, this.innerTypes);
    }

    public List<FieldDef> getFields() {
        return this.fields;
    }

    public List<AnnotationMemberDef> getMembers() {
        return this.members;
    }

    public static AnnotationObjectDefBuilder builder(String name) {
        return new AnnotationObjectDefBuilder(name);
    }

    public static final class AnnotationObjectDefBuilder
    extends AbstractElementBuilder<AnnotationObjectDefBuilder> {
        private final List<AnnotationMemberDef> members = new ArrayList<AnnotationMemberDef>();
        private final List<FieldDef> fields = new ArrayList<FieldDef>();
        private final List<ObjectDef> innerTypes = new ArrayList<ObjectDef>();

        private AnnotationObjectDefBuilder(String className) {
            super(className);
        }

        @NonNull
        public AnnotationObjectDefBuilder addInnerType(@NonNull ObjectDef innerDef) {
            ClassTypeDef innerType = innerDef.asTypeDef();
            String newName = ClassTypeDef.of(this.name).getCanonicalName() + "$" + innerType.getSimpleName();
            this.innerTypes.add(innerDef.withClassName(new ClassTypeDef.ClassName(newName, true)));
            return this;
        }

        public AnnotationObjectDefBuilder addMember(@NonNull AnnotationMemberDef member) {
            this.members.add(member);
            return this;
        }

        public AnnotationObjectDefBuilder addField(@NonNull FieldDef field) {
            this.fields.add(field);
            return this;
        }

        public AnnotationObjectDef build() {
            return new AnnotationObjectDef(this.members, this.fields, new ClassTypeDef.ClassName(this.name), this.modifiers, this.annotations, this.javadoc, this.innerTypes);
        }
    }

    public static final class AnnotationMemberDefBuilder
    extends AbstractElementBuilder<AnnotationMemberDefBuilder> {
        private final TypeDef type;
        private ExpressionDef defaultValue;
        private AnnotationDef defaultAnnotationValue;

        private AnnotationMemberDefBuilder(String name, TypeDef type) {
            super(name);
            this.addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
            this.type = type;
        }

        public AnnotationMemberDefBuilder withDefault(ExpressionDef defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public AnnotationMemberDefBuilder withDefault(AnnotationDef defaultValue) {
            this.defaultAnnotationValue = defaultValue;
            return this;
        }

        public AnnotationMemberDef build() {
            return new AnnotationMemberDef(this.type, this.defaultValue, this.defaultAnnotationValue, this.name, this.modifiers, this.annotations, this.javadoc, this.synthetic);
        }
    }

    public static final class AnnotationMemberDef
    extends AbstractElement {
        @NonNull
        private final TypeDef type;
        @Nullable
        private final ExpressionDef defaultValue;
        @Nullable
        private final AnnotationDef defaultAnnotationValue;

        private AnnotationMemberDef(@NonNull TypeDef type, @Nullable ExpressionDef defaultValue, @Nullable AnnotationDef defaultAnnotationValue, String name, EnumSet<Modifier> modifiers, List<AnnotationDef> annotations, List<String> javadoc, boolean synthetic) {
            super(name, modifiers, annotations, javadoc, synthetic);
            this.type = type;
            this.defaultAnnotationValue = defaultAnnotationValue;
            this.defaultValue = defaultValue;
        }

        public static AnnotationMemberDefBuilder builder(String memberName, TypeDef type) {
            return new AnnotationMemberDefBuilder(memberName, type);
        }

        public TypeDef getType() {
            return this.type;
        }

        public ExpressionDef getDefaultValue() {
            return this.defaultValue;
        }

        public AnnotationDef getAnnotationDefaultValue() {
            return this.defaultAnnotationValue;
        }
    }
}

