/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.sourcegen.model.AnnotationDef;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractElement {
    protected final String name;
    protected final EnumSet<Modifier> modifiers;
    protected final List<AnnotationDef> annotations;
    protected final List<String> javadoc;
    protected final boolean synthetic;

    AbstractElement(String name, EnumSet<Modifier> modifiers, List<AnnotationDef> annotations, List<String> javadoc, boolean synthetic) {
        this.name = name;
        this.modifiers = modifiers;
        this.annotations = Collections.unmodifiableList(annotations);
        this.javadoc = Collections.unmodifiableList(javadoc);
        this.synthetic = synthetic;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public final String getName() {
        return this.name;
    }

    public final Set<Modifier> getModifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    public final Modifier[] getModifiersArray() {
        return (Modifier[])this.modifiers.toArray(Modifier[]::new);
    }

    public final List<AnnotationDef> getAnnotations() {
        return this.annotations;
    }

    public List<String> getJavadoc() {
        return this.javadoc;
    }
}

