/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public class JsonTypeNameMapper
implements NamedAnnotationMapper {
    public String getName() {
        return "com.fasterxml.jackson.annotation.JsonTypeName";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        String n = annotation.stringValue().orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)n)) {
            return Collections.singletonList(AnnotationValue.builder(SerdeConfig.class).member("typeName", n).build());
        }
        return Collections.emptyList();
    }
}

