/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.context.annotation.Executable;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.processor.jackson.ValidatingAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class JsonSetterMapper
extends ValidatingAnnotationMapper {
    @Override
    protected Set<String> getSupportedMemberNames() {
        return Collections.singleton("value");
    }

    @Override
    protected List<AnnotationValue<?>> mapValid(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        String n = annotation.stringValue().orElse(null);
        ArrayList values = new ArrayList(3);
        if (n != null) {
            AnnotationValueBuilder av = AnnotationValue.builder(SerdeConfig.class).member("property", n);
            values.add(av.build());
        }
        values.addAll(Arrays.asList(AnnotationValue.builder(Executable.class).build(), AnnotationValue.builder(SerdeConfig.SerSetter.class).build()));
        return values;
    }

    public String getName() {
        return "com.fasterxml.jackson.annotation.JsonSetter";
    }
}

