/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.bearer;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.handlers.LoginHandler;
import io.micronaut.security.token.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.render.AccessRefreshToken;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requirements(value={@Requires(classes={HttpRequest.class, MutableHttpResponse.class}), @Requires(property="micronaut.security.authentication", value="bearer")})
@Singleton
public class AccessRefreshTokenLoginHandler
implements LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> {
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;

    public AccessRefreshTokenLoginHandler(AccessRefreshTokenGenerator accessRefreshTokenGenerator) {
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
    }

    @Override
    public MutableHttpResponse<?> loginSuccess(Authentication authentication, HttpRequest<?> request) {
        Optional<AccessRefreshToken> accessRefreshTokenOptional = this.accessRefreshTokenGenerator.generate(authentication);
        if (accessRefreshTokenOptional.isPresent()) {
            return HttpResponse.ok((Object)accessRefreshTokenOptional.get());
        }
        return HttpResponse.serverError();
    }

    @Override
    public MutableHttpResponse<?> loginRefresh(Authentication authentication, String refreshToken, HttpRequest<?> request) {
        Optional<AccessRefreshToken> accessRefreshToken = this.accessRefreshTokenGenerator.generate(refreshToken, authentication);
        if (accessRefreshToken.isPresent()) {
            return HttpResponse.ok((Object)accessRefreshToken.get());
        }
        return HttpResponse.serverError();
    }

    @Override
    public MutableHttpResponse<?> loginFailed(AuthenticationResponse authenticationFailed, HttpRequest<?> request) {
        throw new AuthenticationException(authenticationFailed.getMessage().orElse(null));
    }
}

