/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.audit;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.annotation.event.PreUpdate;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.event.listeners.AutoPopulatedEntityEventListener;
import io.micronaut.security.annotation.CreatedBy;
import io.micronaut.security.annotation.UpdatedBy;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.utils.SecurityService;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(classes={AutoPopulatedEntityEventListener.class, EntityEventContext.class})
@Singleton
final class UserAuditingEntityEventListener
extends AutoPopulatedEntityEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(UserAuditingEntityEventListener.class);
    private final SecurityService securityService;
    private final ConversionService conversionService;

    UserAuditingEntityEventListener(SecurityService securityService, ConversionService conversionService) {
        this.securityService = securityService;
        this.conversionService = conversionService;
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        return this.populate(context, PrePersist.class);
    }

    public boolean preUpdate(@NonNull EntityEventContext<Object> context) {
        return this.populate(context, PreUpdate.class);
    }

    @NonNull
    protected List<Class<? extends Annotation>> getEventTypes() {
        return Arrays.asList(PrePersist.class, PreUpdate.class);
    }

    @NonNull
    protected Predicate<RuntimePersistentProperty<Object>> getPropertyPredicate() {
        return property -> {
            AnnotationMetadata annotationMetadata = property.getAnnotationMetadata();
            return annotationMetadata.hasAnnotation(CreatedBy.class) || annotationMetadata.hasAnnotation(UpdatedBy.class);
        };
    }

    private boolean populate(@NonNull EntityEventContext<Object> context, @NonNull Class<? extends Annotation> listenerAnnotation) {
        try {
            this.securityService.getAuthentication().ifPresent(authentication -> {
                HashMap<Class, Object> valueForType = new HashMap<Class, Object>();
                for (RuntimePersistentProperty persistentProperty : this.getApplicableProperties(context.getPersistentEntity())) {
                    BeanProperty beanProperty;
                    Object value;
                    if (!this.shouldSetProperty((RuntimePersistentProperty<Object>)persistentProperty, listenerAnnotation) || (value = valueForType.computeIfAbsent((beanProperty = persistentProperty.getProperty()).getType(), type -> this.convert((Authentication)authentication, (BeanProperty<Object, Object>)beanProperty))) == null) continue;
                    context.setProperty(beanProperty, value);
                }
            });
            return true;
        }
        catch (ConversionErrorException e) {
            return false;
        }
    }

    @Nullable
    private Object convert(@NonNull Authentication authentication, @NonNull BeanProperty<Object, Object> beanProperty) throws ConversionErrorException {
        try {
            return this.conversionService.convertRequired((Object)authentication, beanProperty.getType());
        }
        catch (ConversionErrorException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot convert from {} to {} for bean property {}", new Object[]{authentication.getClass().getSimpleName(), beanProperty.getType(), beanProperty.getName(), e});
            }
            throw e;
        }
    }

    private boolean shouldSetProperty(@NonNull RuntimePersistentProperty<Object> persistentProperty, Class<? extends Annotation> listenerAnnotation) {
        if (listenerAnnotation == PrePersist.class) {
            return true;
        }
        if (listenerAnnotation == PreUpdate.class) {
            return persistentProperty.getAnnotationMetadata().booleanValue(AutoPopulated.class, "updateable").orElse(true);
        }
        return false;
    }
}

