/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public record WwwAuthenticateChallenge(@NonNull String authScheme, @NonNull Map<String, Object> authParameters) {
    private static final String SPACE = " ";
    private static final String EQUAL = "=";
    private static final String COMMA = ",";
    private static final String DOUBLE_QUOTE = "\"";

    @Override
    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.authScheme);
        if (CollectionUtils.isNotEmpty(this.authParameters)) {
            sb.append(SPACE);
            ArrayList<CallSite> params = new ArrayList<CallSite>(this.authParameters.size());
            for (Map.Entry<String, Object> entry : this.authParameters.entrySet()) {
                Object v = entry.getValue();
                if (v instanceof String) {
                    String s = (String)v;
                    params.add((CallSite)((Object)(entry.getKey() + "=\"" + WwwAuthenticateChallenge.escape(s) + DOUBLE_QUOTE)));
                    continue;
                }
                params.add((CallSite)((Object)(entry.getKey() + EQUAL + String.valueOf(v))));
            }
            sb.append(String.join((CharSequence)", ", params));
        }
        return sb.toString();
    }

    private static String escape(String v) {
        StringBuilder out = new StringBuilder(v.length() + 8);
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c == '\"' || c == '\\') {
                out.append('\\');
            }
            out.append(c);
        }
        return out.toString();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String authScheme;
        private LinkedHashMap<String, Object> authParameters;

        @NonNull
        public Builder authScheme(@NonNull String authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        @NonNull
        public Builder param(@NonNull String name, @NonNull Object value) {
            if (this.authParameters == null) {
                this.authParameters = new LinkedHashMap();
            }
            this.authParameters.put(name, value);
            return this;
        }

        @NonNull
        public WwwAuthenticateChallenge build() {
            return new WwwAuthenticateChallenge(this.authScheme, this.authParameters);
        }
    }
}

