/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.utils;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.utils.SecurityService;
import jakarta.inject.Singleton;
import java.security.Principal;
import java.util.Collections;
import java.util.Optional;

@Requires(classes={ServerRequestContext.class})
@Singleton
public class DefaultSecurityService
implements SecurityService {
    private final RolesFinder rolesFinder;

    public DefaultSecurityService(RolesFinder rolesFinder) {
        this.rolesFinder = rolesFinder;
    }

    @Override
    public Optional<String> username() {
        return this.getAuthentication().map(Principal::getName);
    }

    @Override
    public Optional<Authentication> getAuthentication() {
        return ServerRequestContext.currentRequest().flatMap(request -> request.getUserPrincipal(Authentication.class));
    }

    @Override
    public boolean isAuthenticated() {
        return this.getAuthentication().isPresent();
    }

    @Override
    public boolean hasRole(String role) {
        return this.getAuthentication().map(authentication -> this.rolesFinder.hasAnyRequiredRoles(Collections.singletonList(role), authentication.getRoles())).orElse(false);
    }
}

