/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.server.util.locale.HttpLocaleResolver;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.endpoints.LogoutControllerConfiguration;
import io.micronaut.security.endpoints.LogoutControllerConfigurationProperties;
import io.micronaut.security.event.LogoutEvent;
import io.micronaut.security.handlers.LogoutHandler;
import jakarta.inject.Inject;
import java.util.Locale;
import java.util.Optional;

@Requirements(value={@Requires(property="micronaut.security.endpoints.logout.enabled", notEquals="false", defaultValue="true"), @Requires(classes={Controller.class}), @Requires(beans={LogoutHandler.class, HttpHostResolver.class, HttpLocaleResolver.class})})
@Controller(value="${micronaut.security.endpoints.logout.path:/logout}")
@Secured(value={"isAnonymous()"})
public class LogoutController {
    private final LogoutHandler<HttpRequest<?>, MutableHttpResponse<?>> logoutHandler;
    private final ApplicationEventPublisher<LogoutEvent> logoutEventPublisher;
    private final boolean getAllowed;
    private final HttpHostResolver httpHostResolver;
    private final HttpLocaleResolver httpLocaleResolver;
    private final LogoutControllerConfiguration logoutControllerConfiguration;

    @Inject
    public LogoutController(LogoutHandler<HttpRequest<?>, MutableHttpResponse<?>> logoutHandler, ApplicationEventPublisher<LogoutEvent> logoutEventPublisher, LogoutControllerConfiguration logoutControllerConfiguration, HttpHostResolver httpHostResolver, HttpLocaleResolver httpLocaleResolver) {
        this.logoutHandler = logoutHandler;
        this.logoutEventPublisher = logoutEventPublisher;
        this.getAllowed = logoutControllerConfiguration.isGetAllowed();
        this.httpHostResolver = httpHostResolver;
        this.httpLocaleResolver = httpLocaleResolver;
        this.logoutControllerConfiguration = logoutControllerConfiguration;
    }

    @Deprecated(forRemoval=true, since="4.11.0")
    public LogoutController(LogoutHandler<HttpRequest<?>, MutableHttpResponse<?>> logoutHandler, ApplicationEventPublisher<LogoutEvent> logoutEventPublisher, LogoutControllerConfiguration logoutControllerConfiguration, HttpHostResolver httpHostResolver, HttpLocaleResolver httpLocaleResolver, LogoutControllerConfigurationProperties logoutControllerConfigurationProperties) {
        this(logoutHandler, logoutEventPublisher, logoutControllerConfiguration, httpHostResolver, httpLocaleResolver);
    }

    @Deprecated(forRemoval=true, since="4.7.0")
    public LogoutController(LogoutHandler<HttpRequest<?>, MutableHttpResponse<?>> logoutHandler, ApplicationEventPublisher<LogoutEvent> logoutEventPublisher, LogoutControllerConfiguration logoutControllerConfiguration) {
        this(logoutHandler, logoutEventPublisher, logoutControllerConfiguration, request -> null, new HttpLocaleResolver(){

            @NonNull
            public Optional<Locale> resolve(@NonNull HttpRequest<?> context) {
                return Optional.of(Locale.getDefault());
            }

            @NonNull
            public Locale resolveOrDefault(@NonNull HttpRequest<?> context) {
                return Locale.getDefault();
            }
        });
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    public MutableHttpResponse<?> index(HttpRequest<?> request, @Nullable Authentication authentication) {
        Optional contentTypeOptional = request.getContentType();
        if (!contentTypeOptional.isPresent() || !this.logoutControllerConfiguration.getPostContentTypes().contains(((MediaType)contentTypeOptional.get()).toString())) {
            return HttpResponse.notFound();
        }
        return this.handleLogout(request, authentication);
    }

    @Get
    public MutableHttpResponse<?> indexGet(HttpRequest<?> request, @Nullable Authentication authentication) {
        if (!this.getAllowed) {
            return HttpResponse.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED);
        }
        return this.handleLogout(request, authentication);
    }

    protected MutableHttpResponse<?> handleLogout(HttpRequest<?> request, @Nullable Authentication authentication) {
        if (authentication != null) {
            this.logoutEventPublisher.publishEvent((Object)new LogoutEvent(authentication, this.httpHostResolver.resolve(request), this.httpLocaleResolver.resolveOrDefault(request)));
        }
        return this.logoutHandler.logout(request);
    }
}

