/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.AntPathMatcher;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.config.InterceptUrlMapPattern;
import io.micronaut.security.rules.AbstractSecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.RolesFinder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

abstract class InterceptUrlMapRule
extends AbstractSecurityRule<HttpRequest<?>> {
    public static final Integer ORDER = 0;
    private static final Logger LOG = LoggerFactory.getLogger(InterceptUrlMapRule.class);
    private final AntPathMatcher pathMatcher = PathMatcher.ANT;

    protected InterceptUrlMapRule(RolesFinder rolesFinder) {
        super(rolesFinder);
    }

    protected abstract List<InterceptUrlMapPattern> getPatternList();

    @Override
    public Publisher<SecurityRuleResult> check(HttpRequest<?> request, @Nullable Authentication authentication) {
        String path = request.getUri().getPath();
        HttpMethod httpMethod = request.getMethod();
        Predicate<InterceptUrlMapPattern> exactMatch = p -> this.pathMatcher.matches(p.getPattern(), path) && p.getHttpMethod() != null && httpMethod.equals((Object)p.getHttpMethod());
        Predicate<InterceptUrlMapPattern> uriPatternMatchOnly = p -> this.pathMatcher.matches(p.getPattern(), path) && p.getHttpMethod() == null;
        Optional<InterceptUrlMapPattern> matchedPattern = this.getPatternList().stream().filter(exactMatch).findFirst();
        if (!matchedPattern.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No url map pattern exact match found for path [{}] and method [{}]. Searching in patterns with no defined method.", (Object)path, (Object)httpMethod);
            }
            matchedPattern = this.getPatternList().stream().filter(uriPatternMatchOnly).findFirst();
            if (LOG.isDebugEnabled()) {
                if (matchedPattern.isPresent()) {
                    LOG.debug("Url map pattern found for path [{}]. Comparing roles.", (Object)path);
                } else {
                    LOG.debug("No url map pattern match found for path [{}]. Returning unknown.", (Object)path);
                }
            }
        }
        return Mono.from((Publisher)matchedPattern.map(pattern -> this.compareRoles(pattern.getAccess(), this.getRoles(authentication))).orElse((Publisher)Mono.just((Object)((Object)SecurityRuleResult.UNKNOWN))));
    }
}

