/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.propagation;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.http.util.OutgoingHttpRequestProcessor;
import io.micronaut.http.util.OutgoingRequestProcessorMatcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.token.propagation.TokenPropagationConfiguration;
import io.micronaut.security.token.propagation.TokenPropagator;
import java.util.Optional;

@ClientFilter(value={"${micronaut.security.token.propagation.path:/**}"})
@Requirements(value={@Requires(classes={ClientFilter.class}), @Requires(beans={TokenPropagator.class, TokenPropagationConfiguration.class}), @Requires(property="micronaut.security.token.propagation.enabled", value="true")})
public class TokenPropagationHttpClientFilter {
    protected final TokenPropagationConfiguration tokenPropagationConfiguration;
    protected final OutgoingHttpRequestProcessor outgoingHttpRequestProcessor;
    protected final TokenPropagator tokenPropagator;

    public TokenPropagationHttpClientFilter(TokenPropagationConfiguration tokenPropagationConfiguration, OutgoingHttpRequestProcessor outgoingHttpRequestProcessor, TokenPropagator tokenPropagator) {
        this.tokenPropagationConfiguration = tokenPropagationConfiguration;
        this.outgoingHttpRequestProcessor = outgoingHttpRequestProcessor;
        this.tokenPropagator = tokenPropagator;
    }

    @RequestFilter
    public void doFilter(MutableHttpRequest<?> targetRequest) {
        HttpRequest currentRequest;
        Optional tokenOptional;
        Optional currentRequestOptional;
        if (!this.hasExistingToken(targetRequest) && this.outgoingHttpRequestProcessor.shouldProcessRequest((OutgoingRequestProcessorMatcher)this.tokenPropagationConfiguration, targetRequest) && (currentRequestOptional = ServerHttpRequestContext.find()).isPresent() && (tokenOptional = (currentRequest = (HttpRequest)currentRequestOptional.get()).getAttribute(SecurityFilter.TOKEN, String.class)).isPresent()) {
            String token = (String)tokenOptional.get();
            this.tokenPropagator.writeToken(targetRequest, token);
        }
    }

    private boolean hasExistingToken(MutableHttpRequest<?> targetRequest) {
        return this.tokenPropagator.findToken((HttpRequest<?>)targetRequest).isPresent();
    }
}

