/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.config.AuthenticationStrategy;
import io.micronaut.security.config.SecurityConfiguration;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

@Singleton
public class Authenticator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Authenticator.class);
    protected final Collection<AuthenticationProvider<T>> authenticationProviders;
    private final SecurityConfiguration securityConfiguration;

    public Authenticator(Collection<AuthenticationProvider<T>> authenticationProviders, SecurityConfiguration securityConfiguration) {
        this.authenticationProviders = authenticationProviders;
        this.securityConfiguration = securityConfiguration;
    }

    public Publisher<AuthenticationResponse> authenticate(T request, AuthenticationRequest<?, ?> authenticationRequest) {
        if (this.authenticationProviders == null) {
            return Flux.empty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.authenticationProviders.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining()));
        }
        Flux[] emptyArr = new Flux[]{};
        if (this.securityConfiguration != null && this.securityConfiguration.getAuthenticationProviderStrategy() == AuthenticationStrategy.ALL) {
            return Flux.mergeDelayError((int)1, (Publisher[])((Publisher[])this.authenticationProviders.stream().map(provider -> Flux.from(provider.authenticate(request, authenticationRequest)).switchMap(this::handleResponse).switchIfEmpty((Publisher)Flux.error(() -> new AuthenticationException("Provider did not respond. Authentication rejected")))).collect(Collectors.toList()).toArray(emptyArr))).last().onErrorResume(t -> Mono.just((Object)this.authenticationResponseForThrowable((Throwable)t))).flux();
        }
        AtomicReference lastError = new AtomicReference();
        Flux authentication = Flux.mergeDelayError((int)1, (Publisher[])((Publisher[])this.authenticationProviders.stream().map(auth -> auth.authenticate(request, authenticationRequest)).map(Flux::from).map(sequence -> sequence.switchMap(this::handleResponse).onErrorResume(t -> {
            lastError.set(t);
            return Flux.empty();
        })).collect(Collectors.toList()).toArray(emptyArr)));
        return authentication.take(1L).switchIfEmpty((Publisher)Flux.create(emitter -> {
            Throwable error = (Throwable)lastError.get();
            if (error != null) {
                if (error instanceof AuthenticationException) {
                    AuthenticationResponse response = ((AuthenticationException)error).getResponse();
                    if (response != null) {
                        emitter.next((Object)response);
                        emitter.complete();
                    } else {
                        emitter.error(error);
                    }
                } else {
                    emitter.error(error);
                }
            } else {
                emitter.complete();
            }
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR));
    }

    private Flux<AuthenticationResponse> handleResponse(AuthenticationResponse response) {
        if (response.isAuthenticated()) {
            return Flux.just((Object)response);
        }
        return Flux.error((Throwable)new AuthenticationException(response));
    }

    @NonNull
    private AuthenticationResponse authenticationResponseForThrowable(Throwable t) {
        if (Exceptions.isMultiple((Throwable)t)) {
            List exceptions = Exceptions.unwrapMultiple((Throwable)t);
            return new AuthenticationFailed(((Throwable)exceptions.get(exceptions.size() - 1)).getMessage());
        }
        return new AuthenticationFailed(t.getMessage());
    }
}

