/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.security.authentication.AuthenticationRequest;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Introspected
public class UsernamePasswordCredentials
implements Serializable,
AuthenticationRequest<String, String> {
    @NotBlank
    @NotNull
    private String username;
    @NotBlank
    @NotNull
    private String password;

    public UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getIdentity() {
        return this.getUsername();
    }

    @Override
    public String getSecret() {
        return this.getPassword();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        return this.password != null ? this.password.equals(that.password) : that.password == null;
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }
}

