/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.management.endpoint.EndpointSensitivityProcessor;
import io.micronaut.management.endpoint.beans.BeansEndpoint;
import io.micronaut.management.endpoint.env.EnvironmentEndpoint;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.endpoint.info.InfoEndpoint;
import io.micronaut.management.endpoint.loggers.LoggersEndpoint;
import io.micronaut.management.endpoint.refresh.RefreshEndpoint;
import io.micronaut.management.endpoint.routes.RoutesEndpoint;
import io.micronaut.management.endpoint.stop.ServerStopEndpoint;
import io.micronaut.management.endpoint.threads.ThreadDumpEndpoint;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import jakarta.inject.Singleton;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Requires(beans={EndpointSensitivityProcessor.class})
@Singleton
public class SensitiveEndpointRule
implements SecurityRule {
    public static final Integer ORDER = 0;
    private static final Logger LOG = LoggerFactory.getLogger(SensitiveEndpointRule.class);
    private static final String ENDPOINTS_BEANS = "beans";
    private static final String ENDPOINTS_INFO = "info";
    private static final String ENDPOINTS_HEALTH = "health";
    private static final String ENDPOINTS_REFRESH = "refresh";
    private static final String ENDPOINTS_ROUTES = "routes";
    private static final String ENDPOINTS_LOGGERS = "loggers";
    private static final String ENDPOINTS_SERVER_STOP = "serverStop";
    private static final String ENDPOINTS_ENVIRONMENT = "environment";
    private static final String ENDPOINTS_THREAD_DUMP = "threadDump";
    protected final Map<ExecutableMethod, Boolean> endpointMethods;

    public SensitiveEndpointRule(EndpointSensitivityProcessor endpointSensitivityProcessor) {
        this.endpointMethods = endpointSensitivityProcessor.getEndpointMethods();
    }

    @Override
    public Publisher<SecurityRuleResult> check(HttpRequest<?> request, @Nullable RouteMatch<?> routeMatch, @Nullable Authentication authentication) {
        ExecutableMethod method;
        if (routeMatch instanceof MethodBasedRouteMatch && this.endpointMethods.containsKey(method = ((MethodBasedRouteMatch)routeMatch).getExecutableMethod())) {
            return this.check(request, authentication, method);
        }
        return Mono.just((Object)((Object)SecurityRuleResult.UNKNOWN));
    }

    @NonNull
    protected Publisher<SecurityRuleResult> check(@NonNull HttpRequest<?> request, @Nullable Authentication authentication, @NonNull ExecutableMethod<?, ?> method) {
        Boolean sensitive = this.endpointMethods.get(method);
        if (sensitive.booleanValue()) {
            if (authentication == null) {
                return this.checkSensitiveAnonymous(request, method);
            }
            return this.checkSensitiveAuthenticated(request, authentication, method);
        }
        return this.checkNotSensitive(request, authentication, method);
    }

    public int getOrder() {
        return ORDER;
    }

    @NonNull
    protected Publisher<SecurityRuleResult> checkSensitiveAuthenticated(@NonNull HttpRequest<?> request, @NonNull Authentication authentication, @NonNull ExecutableMethod<?, ?> method) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("authentication was found for sensitive {} endpoint. Allowing the request.", (Object)this.endpointName(method));
        }
        return Mono.just((Object)((Object)SecurityRuleResult.ALLOWED));
    }

    @NonNull
    protected Publisher<SecurityRuleResult> checkSensitiveAnonymous(@NonNull HttpRequest<?> request, @NonNull ExecutableMethod<?, ?> method) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} endpoint is sensitive and no authentication was found. Rejecting the request.", (Object)this.endpointName(method));
        }
        return Mono.just((Object)((Object)SecurityRuleResult.REJECTED));
    }

    @NonNull
    protected Publisher<SecurityRuleResult> checkNotSensitive(@NonNull HttpRequest<?> request, @Nullable Authentication authentication, @NonNull ExecutableMethod<?, ?> method) {
        if (LOG.isTraceEnabled()) {
            LOG.debug("{} endpoint is not sensitive. Allowing the request.", (Object)this.endpointName(method));
        }
        return Mono.just((Object)((Object)SecurityRuleResult.ALLOWED));
    }

    @NonNull
    protected String endpointName(@NonNull ExecutableMethod<?, ?> method) {
        Class endpointClass = method.getDeclaringType();
        if (endpointClass == BeansEndpoint.class) {
            return ENDPOINTS_BEANS;
        }
        if (endpointClass == InfoEndpoint.class) {
            return ENDPOINTS_INFO;
        }
        if (endpointClass == HealthEndpoint.class) {
            return ENDPOINTS_HEALTH;
        }
        if (endpointClass == RefreshEndpoint.class) {
            return ENDPOINTS_REFRESH;
        }
        if (endpointClass == RoutesEndpoint.class) {
            return ENDPOINTS_ROUTES;
        }
        if (endpointClass == LoggersEndpoint.class) {
            return ENDPOINTS_LOGGERS;
        }
        if (endpointClass == ServerStopEndpoint.class) {
            return ENDPOINTS_SERVER_STOP;
        }
        if (endpointClass == EnvironmentEndpoint.class) {
            return ENDPOINTS_ENVIRONMENT;
        }
        if (endpointClass == ThreadDumpEndpoint.class) {
            return ENDPOINTS_THREAD_DUMP;
        }
        return method.getDeclaringType().getSimpleName();
    }
}

