/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.DefaultRolesFinder;
import io.micronaut.security.token.MapClaims;
import java.util.ArrayList;
import java.util.List;

@DefaultImplementation(value=DefaultRolesFinder.class)
public interface RolesFinder {
    @NonNull
    public List<String> findInClaims(@NonNull Claims var1);

    default public boolean hasAnyRequiredRoles(@NonNull List<String> requiredRoles, @NonNull Authentication authentication) {
        return this.hasAnyRequiredRoles(requiredRoles, new MapClaims(authentication.getAttributes()));
    }

    default public boolean hasAnyRequiredRoles(@NonNull List<String> requiredRoles, @NonNull Claims claims) {
        return this.hasAnyRequiredRoles(requiredRoles, this.findInClaims(claims));
    }

    default public boolean hasAnyRequiredRoles(@NonNull List<String> requiredRoles, @NonNull List<String> grantedRoles) {
        ArrayList<String> l = new ArrayList<String>(requiredRoles);
        l.retainAll(grantedRoles);
        return !l.isEmpty();
    }
}

