/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints.introspection;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.endpoints.introspection.IntrospectionProcessor;
import io.micronaut.security.endpoints.introspection.IntrospectionRequest;
import io.micronaut.security.endpoints.introspection.IntrospectionResponse;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import io.micronaut.security.token.validator.TokenValidator;
import io.reactivex.Flowable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultIntrospectionProcessor
implements IntrospectionProcessor {
    public static final String CLIENT_ID = "client_id";
    public static final String USERNAME = "username";
    public static final String TOKEN_TYPE = "token_type";
    public static final String ISSUER = "iss";
    public static final String SUBJECT = "sub";
    public static final String EXP = "exp";
    public static final String NOT_BEFORE = "nbf";
    public static final String ISSUED_AT = "iat";
    public static final String JWT_ID = "jti";
    public static final String AUDIENCE = "aud";
    public static final String SCOPE = "scope";
    public static final List<String> FIELDS_ATTRIBUTE_NAMES = Arrays.asList("scope", "username", "client_id", "token_type", "exp", "iat", "sub", "nbf", "aud", "iss", "jti");
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultIntrospectionProcessor.class);
    protected final Collection<TokenValidator> tokenValidators;
    protected final TokenConfiguration tokenConfiguration;
    protected final RefreshTokenValidator refreshTokenValidator;

    public DefaultIntrospectionProcessor(Collection<TokenValidator> tokenValidators, TokenConfiguration tokenConfiguration, @Nullable RefreshTokenValidator refreshTokenValidator) {
        this.tokenValidators = tokenValidators;
        this.tokenConfiguration = tokenConfiguration;
        this.refreshTokenValidator = refreshTokenValidator;
    }

    @Override
    @NonNull
    public Publisher<IntrospectionResponse> introspect(@NonNull IntrospectionRequest introspectionRequest, @NonNull HttpRequest<?> httpRequest) {
        String token = introspectionRequest.getToken();
        return Flowable.fromIterable(this.tokenValidators).flatMap(tokenValidator -> tokenValidator.validateToken(token, httpRequest)).firstElement().map(authentication -> this.createIntrospectionResponse((Authentication)authentication, httpRequest)).defaultIfEmpty((Object)new IntrospectionResponse(this.refreshTokenValidator != null && this.refreshTokenValidator.validate(token).isPresent())).toFlowable();
    }

    @Override
    @NonNull
    public Publisher<IntrospectionResponse> introspect(@NonNull Authentication authentication, @NonNull HttpRequest<?> httpRequest) {
        return Flowable.just((Object)this.createIntrospectionResponse(authentication, httpRequest));
    }

    @NonNull
    public IntrospectionResponse createIntrospectionResponse(@NonNull Authentication authentication, @NonNull HttpRequest<?> httpRequest) {
        IntrospectionResponse introspectionResponse = new IntrospectionResponse(true);
        List<String> processedAttributeNames = this.populateFields(authentication, introspectionResponse);
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        for (String k : authentication.getAttributes().keySet()) {
            if (processedAttributeNames.contains(k)) continue;
            extensions.put(k, authentication.getAttributes().get(k));
        }
        introspectionResponse.setExtensions(extensions);
        if (introspectionResponse.getUsername() == null) {
            introspectionResponse.setUsername(authentication.getName());
        }
        return introspectionResponse;
    }

    @NonNull
    protected List<String> populateFields(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        this.populateScope(authentication, introspectionResponse);
        this.populateUsername(authentication, introspectionResponse);
        this.populateClientId(authentication, introspectionResponse);
        this.populateTokenType(authentication, introspectionResponse);
        this.populateExpiration(authentication, introspectionResponse);
        this.populateIssuedAt(authentication, introspectionResponse);
        this.populateSub(authentication, introspectionResponse);
        this.populateNotBefore(authentication, introspectionResponse);
        this.populateAud(authentication, introspectionResponse);
        this.populateIssuer(authentication, introspectionResponse);
        this.populateJwtId(authentication, introspectionResponse);
        return FIELDS_ATTRIBUTE_NAMES;
    }

    protected void populateScope(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        if (authentication.getAttributes().containsKey(SCOPE)) {
            introspectionResponse.setScope(authentication.getAttributes().get(SCOPE).toString());
        }
    }

    protected void populateTokenType(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        if (authentication.getAttributes().containsKey(TOKEN_TYPE)) {
            introspectionResponse.setTokenType(authentication.getAttributes().get(TOKEN_TYPE).toString());
        }
    }

    protected void populateClientId(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        if (authentication.getAttributes().containsKey(CLIENT_ID)) {
            introspectionResponse.setClientId(authentication.getAttributes().get(CLIENT_ID).toString());
        }
    }

    protected void populateAud(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        if (authentication.getAttributes().containsKey(AUDIENCE)) {
            introspectionResponse.setAud(authentication.getAttributes().get(AUDIENCE).toString());
        }
    }

    protected void populateSub(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        if (authentication.getAttributes().containsKey(SUBJECT)) {
            introspectionResponse.setSub(authentication.getAttributes().get(SUBJECT).toString());
        }
    }

    protected void populateIssuer(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        if (authentication.getAttributes().containsKey(ISSUER)) {
            introspectionResponse.setIss(authentication.getAttributes().get(ISSUER).toString());
        }
    }

    protected void populateJwtId(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        if (authentication.getAttributes().containsKey(JWT_ID)) {
            introspectionResponse.setJti(authentication.getAttributes().get(JWT_ID).toString());
        }
    }

    protected void populateUsername(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        if (authentication.getAttributes().containsKey(USERNAME)) {
            introspectionResponse.setUsername(authentication.getAttributes().get(USERNAME).toString());
        }
    }

    protected void populateExpiration(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        this.secondsSinceEpochOfAttribute(EXP, authentication).ifPresent(introspectionResponse::setExp);
    }

    protected Optional<Long> secondsSinceEpochOfAttribute(@NonNull String attributeName, @NonNull Authentication authentication) {
        block5: {
            if (authentication.getAttributes().containsKey(attributeName)) {
                Object obj = authentication.getAttributes().get(attributeName);
                if (obj instanceof Long) {
                    return Optional.of((Long)obj);
                }
                if (obj instanceof Date) {
                    return Optional.of(DefaultIntrospectionProcessor.toSecondsSinceEpoch((Date)obj));
                }
                try {
                    return Optional.of(Long.valueOf(obj.toString()));
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn("cannot convert attribute {} with value {} to Integer", (Object)attributeName, (Object)obj.toString());
                }
            }
        }
        return Optional.empty();
    }

    protected void populateNotBefore(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        this.secondsSinceEpochOfAttribute(NOT_BEFORE, authentication).ifPresent(introspectionResponse::setNbf);
    }

    protected void populateIssuedAt(@NonNull Authentication authentication, @NonNull IntrospectionResponse introspectionResponse) {
        this.secondsSinceEpochOfAttribute(ISSUED_AT, authentication).ifPresent(introspectionResponse::setIat);
    }

    public static long toSecondsSinceEpoch(Date date) {
        return date.getTime() / 1000L;
    }
}

