/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.session;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.token.TokenAuthenticationFetcher;
import io.micronaut.session.Session;
import io.micronaut.session.http.HttpSessionFilter;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
public class SessionAuthenticationFetcher
implements AuthenticationFetcher {
    public static final Integer ORDER = TokenAuthenticationFetcher.ORDER - 100;

    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        return Maybe.create(emitter -> {
            Optional opt = request.getAttributes().get(HttpSessionFilter.SESSION_ATTRIBUTE, Session.class);
            if (opt.isPresent()) {
                Session session = (Session)opt.get();
                Optional authentication = session.get(SecurityFilter.AUTHENTICATION, Authentication.class);
                authentication.ifPresent(arg_0 -> ((MaybeEmitter)emitter).onSuccess(arg_0));
            }
            emitter.onComplete();
        }).toFlowable();
    }

    public int getOrder() {
        return ORDER;
    }
}

