/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.session;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.functional.ThrowingSupplier;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.AuthenticationUserDetailsAdapter;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.errors.PriorToLoginPersistence;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.handlers.RedirectingLoginHandler;
import io.micronaut.security.session.SecuritySessionConfiguration;
import io.micronaut.security.session.SessionAuthenticationModeCondition;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.session.http.SessionForRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Requires(condition=SessionAuthenticationModeCondition.class)
@Singleton
public class SessionLoginHandler
implements RedirectingLoginHandler {
    protected final String loginSuccess;
    protected final String loginFailure;
    protected final RedirectConfiguration redirectConfiguration;
    protected final SessionStore<Session> sessionStore;
    private final TokenConfiguration tokenConfiguration;
    private final PriorToLoginPersistence priorToLoginPersistence;

    @Deprecated
    public SessionLoginHandler(SecuritySessionConfiguration securitySessionConfiguration, SessionStore<Session> sessionStore, TokenConfiguration tokenConfiguration) {
        this(securitySessionConfiguration.toRedirectConfiguration(), sessionStore, tokenConfiguration, null);
    }

    @Inject
    public SessionLoginHandler(RedirectConfiguration redirectConfiguration, SessionStore<Session> sessionStore, TokenConfiguration tokenConfiguration, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        this.loginFailure = redirectConfiguration.getLoginFailure();
        this.loginSuccess = redirectConfiguration.getLoginSuccess();
        this.redirectConfiguration = redirectConfiguration;
        this.sessionStore = sessionStore;
        this.tokenConfiguration = tokenConfiguration;
        this.priorToLoginPersistence = priorToLoginPersistence;
    }

    public MutableHttpResponse<?> loginSuccess(UserDetails userDetails, HttpRequest<?> request) {
        Session session = SessionForRequest.find(request).orElseGet(() -> SessionForRequest.create(this.sessionStore, (HttpRequest)request));
        session.put(SecurityFilter.AUTHENTICATION, (Object)new AuthenticationUserDetailsAdapter(userDetails, this.tokenConfiguration.getRolesName(), this.tokenConfiguration.getNameKey()));
        try {
            Optional originalUri;
            MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.SEE_OTHER);
            ThrowingSupplier uriSupplier = () -> new URI(this.loginSuccess);
            if (this.priorToLoginPersistence != null && (originalUri = this.priorToLoginPersistence.getOriginalUri(request, response)).isPresent()) {
                uriSupplier = originalUri::get;
            }
            response.getHeaders().location((URI)uriSupplier.get());
            return response;
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    public MutableHttpResponse<?> loginRefresh(UserDetails userDetails, String refreshToken, HttpRequest<?> request) {
        throw new UnsupportedOperationException("Session based logins do not support refresh");
    }

    public MutableHttpResponse<?> loginFailed(AuthenticationResponse authenticationFailed, HttpRequest<?> request) {
        try {
            URI location = new URI(this.loginFailure);
            return HttpResponse.seeOther((URI)location);
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }
}

