/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface OpenIdProviderMetadata
extends Named {
    @NonNull
    public String getIssuer();

    @NonNull
    public String getAuthorizationEndpoint();

    @NonNull
    public String getTokenEndpoint();

    @Nullable
    public String getUserinfoEndpoint();

    @NonNull
    public String getJwksUri();

    @Nullable
    public String getRegistrationEndpoint();

    @Nullable
    public List<String> getScopesSupported();

    @Nullable
    public List<String> getResponseTypesSupported();

    @Nullable
    public List<String> getResponseModesSupported();

    @Nullable
    public List<String> getGrantTypesSupported();

    @Nullable
    public List<String> getAcrValuesSupported();

    @NonNull
    public List<String> getSubjectTypesSupported();

    @NonNull
    public List<String> getIdTokenSigningAlgValuesSupported();

    @Nullable
    public List<String> getIdTokenEncryptionEncValuesSupported();

    @Deprecated(forRemoval=true)
    @Nullable
    public List<String> getUserInfoEncryptionAlgValuesSupported();

    @Nullable
    default public List<String> getUserinfoEncryptionAlgValuesSupported() {
        return this.getUserinfoEncryptionEncValuesSupported();
    }

    @Nullable
    public List<String> getUserinfoEncryptionEncValuesSupported();

    @Nullable
    public List<String> getRequestObjectSigningAlgValuesSupported();

    @Nullable
    public List<String> getRequestObjectEncryptionAlgValuesSupported();

    @Nullable
    public List<String> getRequestObjectEncryptionEncValuesSupported();

    @Nullable
    public List<String> getTokenEndpointAuthMethodsSupported();

    @Nullable
    public List<String> getTokenEndpointAuthSigningAlgValuesSupported();

    @Nullable
    public List<String> getDisplayValuesSupported();

    @Nullable
    public List<String> getClaimTypesSupported();

    @Nullable
    public List<String> getClaimsSupported();

    @Nullable
    public String getServiceDocumentation();

    @Nullable
    public List<String> getClaimsLocalesSupported();

    @Nullable
    public List<String> getUriLocalesSupported();

    @Nullable
    public Boolean getClaimsParameterSupported();

    @Nullable
    public Boolean getRequestParameterSupported();

    @Nullable
    public Boolean getRequestUriParameterSupported();

    @Nullable
    public Boolean getRequireRequestUriRegistration();

    @Nullable
    public String getOpPolicyUri();

    @Nullable
    public String getOpTosUri();

    @Nullable
    public List<String> getCodeChallengeMethodsSupported();

    @Nullable
    public List<String> getIntrospectionEndpointAuthMethodsSupported();

    @Nullable
    public List<String> getRevocationEndpointAuthMethodsSupported();

    @Nullable
    public String getIntrospectionEndpoint();

    @Nullable
    public String getRevocationEndpoint();

    @Nullable
    public String getCheckSessionIframe();

    @Nullable
    public String getEndSessionEndpoint();

    @NonNull
    default public Optional<List<AuthenticationMethod>> getTokenEndpointAuthMethods() {
        List<String> authMethodsSupported = this.getTokenEndpointAuthMethodsSupported();
        if (authMethodsSupported == null) {
            return Optional.empty();
        }
        return Optional.of(authMethodsSupported.stream().map(String::toUpperCase).map(AuthenticationMethod::valueOf).collect(Collectors.toList()));
    }
}

