/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.oauth2.client.ClientUtils;
import io.micronaut.security.oauth2.client.OpenIdClient;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.DefaultSecureEndpoint;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRedirectHandler;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.OpenIdAuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponseException;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponseHandler;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class DefaultOpenIdClient
implements OpenIdClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOpenIdClient.class);
    private final OauthClientConfiguration clientConfiguration;
    private final Supplier<OpenIdProviderMetadata> openIdProviderMetadata;
    private final OpenIdAuthenticationMapper authenticationMapper;
    private final AuthorizationRedirectHandler redirectUrlBuilder;
    private final OpenIdAuthorizationResponseHandler authorizationResponseHandler;
    private final Supplier<SecureEndpoint> tokenEndpoint;
    private final BeanContext beanContext;
    private final EndSessionEndpoint endSessionEndpoint;

    public DefaultOpenIdClient(OauthClientConfiguration clientConfiguration, Supplier<OpenIdProviderMetadata> openIdProviderMetadata, @Nullable OpenIdAuthenticationMapper authenticationMapper, AuthorizationRedirectHandler redirectUrlBuilder, OpenIdAuthorizationResponseHandler authorizationResponseHandler, BeanContext beanContext, @Nullable EndSessionEndpoint endSessionEndpoint) {
        this.clientConfiguration = clientConfiguration;
        this.openIdProviderMetadata = openIdProviderMetadata;
        this.authenticationMapper = authenticationMapper;
        this.redirectUrlBuilder = redirectUrlBuilder;
        this.authorizationResponseHandler = authorizationResponseHandler;
        this.beanContext = beanContext;
        this.endSessionEndpoint = endSessionEndpoint;
        this.tokenEndpoint = SupplierUtil.memoized(this::getTokenEndpoint);
    }

    @Override
    public String getName() {
        return this.clientConfiguration.getName();
    }

    @Override
    public boolean supportsEndSession() {
        return this.endSessionEndpoint != null;
    }

    @Override
    public Optional<MutableHttpResponse<?>> endSessionRedirect(HttpRequest<?> request, Authentication authentication) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting end session flow to provider [{}]", (Object)this.getName());
        }
        return Optional.ofNullable(this.endSessionEndpoint).map(esr -> esr.getUrl(request, authentication)).map(url -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Redirecting to [{}]", url);
            }
            return HttpResponse.status((HttpStatus)HttpStatus.FOUND).header((CharSequence)"Location", (CharSequence)url);
        });
    }

    @Override
    public Publisher<MutableHttpResponse<?>> authorizationRedirect(HttpRequest<?> originating) {
        OpenIdProviderMetadata openIdProviderMetadataResolved = this.openIdProviderMetadata.get();
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)this.beanContext.createBean(OpenIdAuthorizationRequest.class, new Object[]{originating, this.clientConfiguration, openIdProviderMetadataResolved});
        String endpoint = openIdProviderMetadataResolved.getAuthorizationEndpoint();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting authorization code grant flow to provider [{}]. Redirecting to [{}]", (Object)this.getName(), (Object)endpoint);
        }
        return Flux.just(this.redirectUrlBuilder.redirect(authorizationRequest, endpoint));
    }

    @Override
    public Publisher<AuthenticationResponse> onCallback(HttpRequest<Map<String, Object>> request) {
        ConvertibleMultiValues<String> responseData = ClientUtils.getResponseData(request);
        if (this.isErrorCallback(responseData)) {
            AuthorizationErrorResponse errorResponse = (AuthorizationErrorResponse)this.beanContext.createBean(AuthorizationErrorResponse.class, new Object[]{request});
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received an authorization error response from provider [{}]. Error: [{}]", (Object)this.getName(), (Object)errorResponse.getError());
            }
            throw new AuthorizationErrorResponseException(errorResponse);
        }
        OpenIdAuthorizationResponse authorizationResponse = (OpenIdAuthorizationResponse)this.beanContext.createBean(OpenIdAuthorizationResponse.class, new Object[]{request});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received a successful authorization response from provider [{}]", (Object)this.getName());
        }
        return this.authorizationResponseHandler.handle(authorizationResponse, this.clientConfiguration, this.openIdProviderMetadata.get(), this.authenticationMapper, this.tokenEndpoint.get());
    }

    protected boolean isErrorCallback(ConvertibleMultiValues<String> responseData) {
        return responseData.contains("error");
    }

    protected SecureEndpoint getTokenEndpoint() {
        Optional<List<AuthenticationMethod>> authMethodsSupported = this.openIdProviderMetadata.get().getTokenEndpointAuthMethods();
        return new DefaultSecureEndpoint(this.openIdProviderMetadata.get().getTokenEndpoint(), authMethodsSupported.orElse(null));
    }
}

