/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import java.util.Optional;

public abstract class CookiePersistence {
    protected final CookieConfiguration cookieConfiguration;

    protected CookiePersistence(CookieConfiguration cookieConfiguration) {
        this.cookieConfiguration = cookieConfiguration;
    }

    protected Optional<String> retrieveValue(HttpRequest<?> request) {
        Cookie cookie = request.getCookies().get((CharSequence)this.cookieConfiguration.getCookieName());
        return Optional.ofNullable(cookie).map(Cookie::getValue);
    }

    protected void save(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @Nullable String value) {
        if (value != null) {
            Cookie cookie = Cookie.of((String)this.cookieConfiguration.getCookieName(), (String)value);
            cookie.configure(this.cookieConfiguration, request.isSecure());
            response.cookie(cookie);
        }
    }
}

