/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response;

import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.functional.ThrowingFunction;
import io.micronaut.security.oauth2.endpoint.token.response.Address;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdClaims;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JWTOpenIdClaims
implements OpenIdClaims {
    private final JWTClaimsSet claimsSet;

    public JWTOpenIdClaims(JWTClaimsSet claimsSet) {
        this.claimsSet = claimsSet;
    }

    @Override
    @NonNull
    public String getIssuer() {
        return this.claimsSet.getIssuer();
    }

    @Override
    @NonNull
    public List<String> getAudience() {
        return this.claimsSet.getAudience();
    }

    @Override
    @NonNull
    public Date getExpirationTime() {
        return this.claimsSet.getExpirationTime();
    }

    @Override
    @NonNull
    public Date getIssuedAt() {
        return this.claimsSet.getIssueTime();
    }

    @Override
    @NonNull
    public String getSubject() {
        return this.claimsSet.getSubject();
    }

    @Override
    @Nullable
    public String getAuthorizedParty() {
        return (String)this.getClaim("azp", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public List<String> getAuthenticationMethodReferences() {
        return (List)this.getClaim("amr", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringListClaim(arg_0));
    }

    @Override
    @Nullable
    public String getAuthenticationContextClassReference() {
        return (String)this.getClaim("acr", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public Integer getAuthenticationTime() {
        return (Integer)this.getClaim("auth_time", arg_0 -> ((JWTClaimsSet)this.claimsSet).getIntegerClaim(arg_0));
    }

    @Override
    @Nullable
    public String getNonce() {
        return (String)this.getClaim("nonce", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getName() {
        return (String)this.getClaim("name", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getGivenName() {
        return (String)this.getClaim("given_name", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return (String)this.getClaim("family_name", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getMiddleName() {
        return (String)this.getClaim("middle_name", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getNickname() {
        return (String)this.getClaim("nickname", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getPreferredUsername() {
        return (String)this.getClaim("preferred_username", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getProfile() {
        return (String)this.getClaim("profile", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getPicture() {
        return (String)this.getClaim("picture", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getWebsite() {
        return (String)this.getClaim("website", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getEmail() {
        return (String)this.getClaim("email", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public Boolean isEmailVerified() {
        return (Boolean)this.getClaim("email_verified", arg_0 -> ((JWTClaimsSet)this.claimsSet).getBooleanClaim(arg_0));
    }

    @Override
    @Nullable
    public String getGender() {
        return (String)this.getClaim("gender", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getBirthday() {
        return (String)this.getClaim("birthdate", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getZoneinfo() {
        return (String)this.getClaim("zoneinfo", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getLocale() {
        return (String)this.getClaim("locale", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public String getPhoneNumber() {
        return (String)this.getClaim("phone_number", arg_0 -> ((JWTClaimsSet)this.claimsSet).getStringClaim(arg_0));
    }

    @Override
    @Nullable
    public Boolean isPhoneNumberVerified() {
        return (Boolean)this.getClaim("phone_number_verified", arg_0 -> ((JWTClaimsSet)this.claimsSet).getBooleanClaim(arg_0));
    }

    @Override
    @Nullable
    public Address getAdress() {
        Object addressClaim = this.claimsSet.getClaim("address");
        if (addressClaim instanceof Address) {
            return (Address)addressClaim;
        }
        if (addressClaim instanceof Map) {
            return new Address((Map)addressClaim);
        }
        return null;
    }

    @Override
    @Nullable
    public Integer getUpdatedAt() {
        return (Integer)this.getClaim("updated_at", arg_0 -> ((JWTClaimsSet)this.claimsSet).getIntegerClaim(arg_0));
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claimsSet.getClaims();
    }

    private <R> R getClaim(String claim, ThrowingFunction<String, R, ParseException> function) {
        try {
            return (R)function.apply((Object)claim);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nullable
    public Object get(String claimName) {
        return this.claimsSet.getClaim(claimName);
    }

    @NonNull
    public Set<String> names() {
        return this.claimsSet.getClaims().keySet();
    }

    public boolean contains(String claimName) {
        return this.claimsSet.getClaims().containsKey(claimName);
    }
}

