/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.response;

import com.nimbusds.jwt.JWT;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.persistence.PkcePersistence;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponseHandler;
import io.micronaut.security.oauth2.endpoint.authorization.state.InvalidStateException;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.authorization.state.validation.StateValidator;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.OpenIdCodeTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.JWTOpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;
import io.micronaut.security.oauth2.url.OauthRouteUrlBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Requirements(value={@Requires(beans={OpenIdTokenResponseValidator.class, OpenIdAuthenticationMapper.class, TokenEndpointClient.class, OauthRouteUrlBuilder.class}), @Requires(configuration="io.micronaut.security.token.jwt")})
@Singleton
public class DefaultOpenIdAuthorizationResponseHandler<T>
implements OpenIdAuthorizationResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOpenIdAuthorizationResponseHandler.class);
    private final OpenIdTokenResponseValidator tokenResponseValidator;
    private final OpenIdAuthenticationMapper defaultAuthenticationMapper;
    private final TokenEndpointClient tokenEndpointClient;
    private final OauthRouteUrlBuilder<T> oauthRouteUrlBuilder;
    @Nullable
    private final StateValidator stateValidator;
    @Nullable
    private final PkcePersistence pkcePersistence;
    private final ExecutorService blockingExecutor;

    @Inject
    public DefaultOpenIdAuthorizationResponseHandler(OpenIdTokenResponseValidator tokenResponseValidator, OpenIdAuthenticationMapper authenticationMapper, TokenEndpointClient tokenEndpointClient, OauthRouteUrlBuilder<T> oauthRouteUrlBuilder, @Nullable StateValidator stateValidator, @Nullable PkcePersistence pkcePersistence, @Named(value="blocking") ExecutorService blockingExecutor) {
        this.tokenResponseValidator = tokenResponseValidator;
        this.defaultAuthenticationMapper = authenticationMapper;
        this.tokenEndpointClient = tokenEndpointClient;
        this.oauthRouteUrlBuilder = oauthRouteUrlBuilder;
        this.stateValidator = stateValidator;
        this.pkcePersistence = pkcePersistence;
        this.blockingExecutor = blockingExecutor;
    }

    @Deprecated(forRemoval=true, since="2.7.0")
    public DefaultOpenIdAuthorizationResponseHandler(OpenIdTokenResponseValidator tokenResponseValidator, OpenIdAuthenticationMapper authenticationMapper, TokenEndpointClient tokenEndpointClient, OauthRouteUrlBuilder<T> oauthRouteUrlBuilder, @Nullable StateValidator stateValidator, @Nullable PkcePersistence pkcePersistence) {
        this(tokenResponseValidator, authenticationMapper, tokenEndpointClient, oauthRouteUrlBuilder, stateValidator, pkcePersistence, Executors.newCachedThreadPool());
    }

    @Override
    public Publisher<AuthenticationResponse> handle(OpenIdAuthorizationResponse authorizationResponse, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, @Nullable OpenIdAuthenticationMapper authenticationMapper, SecureEndpoint tokenEndpoint) {
        try {
            this.validateState(authorizationResponse, clientConfiguration);
        }
        catch (InvalidStateException e) {
            return Flux.just((Object)new AuthenticationFailed("State validation failed: " + e.getMessage()));
        }
        return Flux.from(this.sendRequest(authorizationResponse, clientConfiguration, tokenEndpoint)).switchMap(response -> Flux.from(this.createAuthenticationResponse(authorizationResponse.getNonce(), clientConfiguration, openIdProviderMetadata, (OpenIdTokenResponse)response, authenticationMapper, authorizationResponse.getState())).map(AuthenticationResponse.class::cast));
    }

    private void validateState(OpenIdAuthorizationResponse authorizationResponse, OauthClientConfiguration clientConfiguration) throws InvalidStateException {
        if (this.stateValidator != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Validating state found in the authorization response from provider [{}]", (Object)clientConfiguration.getName());
            }
            State state = authorizationResponse.getState();
            this.stateValidator.validate(authorizationResponse.getCallbackRequest(), state);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Skipping state validation, no state validator found");
        }
    }

    private Publisher<OpenIdTokenResponse> sendRequest(OpenIdAuthorizationResponse authorizationResponse, OauthClientConfiguration clientConfiguration, SecureEndpoint tokenEndpoint) {
        OpenIdCodeTokenRequestContext requestContext = new OpenIdCodeTokenRequestContext(authorizationResponse, this.oauthRouteUrlBuilder, tokenEndpoint, clientConfiguration, this.pkcePersistence == null ? null : (String)this.pkcePersistence.retrieveCodeVerifier(authorizationResponse.getCallbackRequest()).orElse(null));
        return Flux.from(this.tokenEndpointClient.sendRequest(requestContext)).publishOn(Schedulers.fromExecutorService((ExecutorService)this.blockingExecutor));
    }

    private Flux<AuthenticationResponse> createAuthenticationResponse(String nonce, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, OpenIdTokenResponse openIdTokenResponse, @Nullable OpenIdAuthenticationMapper authenticationMapper, @Nullable State state) {
        try {
            Optional<Publisher<AuthenticationResponse>> authenticationResponse = this.validateOpenIdTokenResponse(nonce, clientConfiguration, openIdProviderMetadata, openIdTokenResponse, authenticationMapper, state);
            if (authenticationResponse.isPresent()) {
                return Flux.from(authenticationResponse.get());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Token validation failed. Failing authentication");
            }
            return Flux.error((Throwable)AuthenticationResponse.exception((String)"JWT validation failed"));
        }
        catch (ParseException e) {
            return Flux.error((Throwable)e);
        }
    }

    private Optional<Publisher<AuthenticationResponse>> validateOpenIdTokenResponse(String nonce, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, OpenIdTokenResponse openIdTokenResponse, @Nullable OpenIdAuthenticationMapper authenticationMapper, @Nullable State state) throws ParseException {
        Optional<JWT> jwt;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Token endpoint returned a success response. Validating the JWT");
        }
        if ((jwt = this.tokenResponseValidator.validate(clientConfiguration, openIdProviderMetadata, openIdTokenResponse, nonce)).isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Token validation succeeded. Creating a user details");
            }
            JWTOpenIdClaims claims = new JWTOpenIdClaims(jwt.get().getJWTClaimsSet());
            OpenIdAuthenticationMapper openIdAuthenticationMapper = authenticationMapper != null ? authenticationMapper : this.defaultAuthenticationMapper;
            return Optional.of(Flux.from(openIdAuthenticationMapper.createAuthenticationResponse(clientConfiguration.getName(), openIdTokenResponse, claims, state)).map(AuthenticationResponse.class::cast));
        }
        return Optional.empty();
    }
}

