/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.pkce;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceConfiguration;
import jakarta.validation.constraints.Pattern;
import java.util.Optional;
import reactor.util.annotation.NonNull;

@ConfigurationProperties(value="micronaut.security.oauth2.pkce")
public class PkceConfigurationProperties
implements PkceConfiguration {
    public static final String PREFIX = "micronaut.security.oauth2.pkce";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String PERSISTENCE_COOKIE = "cookie";
    public static final String PERSISTENCE_SESSION = "session";
    private static final String DEFAULT_PERSISTENCE = "cookie";
    private static final int DEFAULT_CODE_VERIFIER_ENTROPY = 64;
    private String persistence = "cookie";
    private boolean enabled = true;
    private int entropy = 64;

    @Override
    public int getEntropy() {
        return this.entropy;
    }

    public void setEntropy(int entropy) {
        this.entropy = entropy;
    }

    @Override
    @NonNull
    public Optional<@Pattern(regexp="cookie|session") String> getPersistence() {
        return Optional.ofNullable(this.persistence);
    }

    public void setPersistence(String persistence) {
        this.persistence = persistence;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

