/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.provider.ReactiveAuthenticationProvider;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.password.PasswordGrantCondition;
import io.micronaut.security.oauth2.endpoint.token.request.password.ReactiveOauthPasswordAuthenticationProvider;
import io.micronaut.security.oauth2.endpoint.token.request.password.ReactiveOpenIdPasswordAuthenticationProvider;
import io.micronaut.security.oauth2.endpoint.token.response.DefaultOpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OauthAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.validation.ReactiveOpenIdTokenResponseValidator;

@Factory
@Internal
class PasswordGrantFactory {
    PasswordGrantFactory() {
    }

    @EachBean(value=OauthClientConfiguration.class)
    @Requires(condition=PasswordGrantCondition.class)
    ReactiveAuthenticationProvider passwordGrantProvider(@Parameter OauthClientConfiguration clientConfiguration, @Parameter @Nullable OauthAuthenticationMapper authenticationMapper, @Parameter @Nullable OpenIdAuthenticationMapper openIdAuthenticationMapper, @Parameter @Nullable OpenIdProviderMetadata openIdProviderMetadata, TokenEndpointClient tokenEndpointClient, @Nullable DefaultOpenIdAuthenticationMapper defaultOpenIdAuthenticationMapper, @Nullable ReactiveOpenIdTokenResponseValidator tokenResponseValidator) {
        if (clientConfiguration.getToken().isPresent()) {
            return new ReactiveOauthPasswordAuthenticationProvider(tokenEndpointClient, clientConfiguration, authenticationMapper);
        }
        if (openIdAuthenticationMapper == null) {
            openIdAuthenticationMapper = defaultOpenIdAuthenticationMapper;
        }
        return new ReactiveOpenIdPasswordAuthenticationProvider(clientConfiguration, openIdProviderMetadata, tokenEndpointClient, openIdAuthenticationMapper, tokenResponseValidator);
    }
}

